import type { ScreenBase } from '../service/screen-base';
import type { ScreenExtension } from '../types';
import type { ValueOrCallbackKeysExtractor, ValueOrCallbackReturnExtractor, ValueOrCallbackWithFieldValue } from '../utils/types';
import type { PageActionProperties } from './control-objects';
import type { HasAccessRights } from './field/traits';
import type { ComponentKey } from './types';
export interface ComponentProperties<CT extends ScreenExtension<CT> = ScreenBase> extends HasAccessRights {
    /**
     * Whether the HTML element is disabled or not. Defaults to false
     *
     * The difference with readOnly is that disabled suggests that the field is not editable
     * for some validation reason (e.g. a button which can't be clicked due to validation errors)
     */
    isDisabled?: ValueOrCallbackWithFieldValue<CT, boolean>;
    /** The type of the corresponding control object, for internal use only. */
    _controlObjectType?: ComponentKey | null;
}
/**
 * Any element than can be placed inside a page and can be interacted with (i.e. retrieving
 * and/or setting element's properties values)
 */
export declare abstract class BaseControlObject<CT extends ScreenExtension<CT>, S extends ComponentProperties<CT>> {
    protected readonly screenId: string;
    protected readonly elementId: string;
    protected readonly _getUiComponentProperties: (screenId: string, elementId: string) => S;
    protected readonly _setUiComponentProperties: (screenId: string, elementId: string, state: PageActionProperties<ScreenExtension<CT>>) => void;
    protected readonly _componentKey: ComponentKey;
    static readonly defaultUiProperties: Partial<ComponentProperties>;
    constructor(screenId: string, elementId: string, _getUiComponentProperties: (screenId: string, elementId: string) => S, _setUiComponentProperties: (screenId: string, elementId: string, state: PageActionProperties<ScreenExtension<CT>>) => void, _componentKey: ComponentKey);
    protected get uiComponentProperties(): S;
    /**
     * Get and clone the property value to ensure immutability. Function properties are not cloned.
     * @param propertyName
     * @returns deep cloned property value
     */
    protected getUiComponentProperty<K extends keyof S>(propertyName: K): S[K];
    protected getResolvedProperty<K extends ValueOrCallbackKeysExtractor<S>>(key: K, skipHexFormat?: boolean): ValueOrCallbackReturnExtractor<S, K>;
    /**
     * Clone and then set the property value to ensure immutability. Function properties are not cloned.
     * @param propertyName
     * @param propertyValue
     */
    protected setUiComponentProperties<K extends keyof S>(propertyName: K, propertyValue: S[K]): void;
    /**
     * Only returns a READ-ONLY copy of the properties. Any updates to the object will not affect to the framework.
     */
    get properties(): S;
    /** Id of the control object */
    get id(): string;
    /**
     * Whether the HTML element is editable (disabled = false) or not (disabled = true)
     *
     * The difference with readOnly is that disabled suggests that the field is not editable
     * for some validation reason (e.g. a button which can be clicked due to validation errors)
     */
    isDisabled?: boolean;
    get componentType(): ComponentKey;
}
//# sourceMappingURL=base-control-object.d.ts.map