import type { Dict } from '@sage/xtrem-shared';
import type { DataTypeDetails, FormattedNodeDetails, FormattedNodeDetailsProperty } from '../service/metadata-types';
import { AbstractDecorator } from './abstract-decorator';
import type { DecoratorTarget, FieldDecoratorProps, FieldKey, FieldValue, MetadataProps } from './types';
export declare class AbstractFieldDecorator<T extends FieldKey> extends AbstractDecorator<T> {
    protected target: DecoratorTarget<T>;
    protected elementId: string;
    protected componentType: T;
    protected nodeTypes: Dict<FormattedNodeDetails>;
    protected dataTypes: Dict<DataTypeDetails>;
    protected _metadataProps: MetadataProps<T>;
    constructor(target: DecoratorTarget<T>, elementId: string, componentType: T, nodeTypes: Dict<FormattedNodeDetails>, dataTypes: Dict<DataTypeDetails>, _metadataProps: MetadataProps<T>);
    parseRawServerValue(value: any): FieldValue<T>;
    protected getComponentPropertiesFromDataType(_dataType: DataTypeDetails, _propertyDetails: FormattedNodeDetailsProperty): Partial<FieldDecoratorProps<T>>;
    private computeDefaultPropertiesForNonTransientField;
    /**
     * Compute default decorator properties with fields that have a `node` decorator property
     * @param fieldNode
     * @returns
     */
    private computeDefaultPropertiesForTransientField;
    protected setUiComponentProperties: () => this;
}
//# sourceMappingURL=abstract-field-decorator.d.ts.map