"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.filterableGraphqlTypes = exports.getInternalPathFromExternal = exports.NUMERIC_TYPES = void 0;
const xtrem_shared_1 = require("@sage/xtrem-shared");
const lodash_1 = require("lodash");
exports.NUMERIC_TYPES = [xtrem_shared_1.GraphQLTypes.Int, xtrem_shared_1.GraphQLTypes.Float, xtrem_shared_1.GraphQLTypes.Decimal];
const isValidQueryParameter = (str) => {
    try {
        const params = JSON.parse(atob(str));
        return (0, lodash_1.isObject)(params);
    }
    catch {
        return false;
    }
};
const getInternalPathFromExternal = () => {
    const url = new URL(window.location.href);
    let queryParams = Array.from(url.searchParams.keys())
        .filter(key => {
        // INFO: Query paremeters which should be excluded from base64 encoding, such as the
        //       pendo designer can be added here.
        const exceptions = ['pendo-designer'];
        return !exceptions.includes(key);
    })
        .reduce((prevValue, key) => {
        return { ...prevValue, [key]: url.searchParams.get(key) };
    }, {});
    const path = window.location.href
        .replace(`${window.location.origin}/`, '')
        .replace('index.html', '')
        .replace('#', '')
        .replace(/(\?[^?#]*)$/, '');
    const components = path.split('/');
    const queryParameterSegment = components[3] || '';
    if (isValidQueryParameter(queryParameterSegment)) {
        queryParams = {
            ...queryParams,
            ...JSON.parse(atob(queryParameterSegment)),
        };
    }
    else if (!(0, lodash_1.isNil)(queryParameterSegment) && !(0, lodash_1.isEmpty)(queryParameterSegment)) {
        queryParams._id = String(queryParameterSegment);
    }
    if (!(0, lodash_1.isEmpty)(queryParams)) {
        const encodedParams = btoa(JSON.stringify(queryParams));
        if (components.length === 3) {
            components.push(encodedParams);
        }
        else {
            components[3] = encodedParams;
        }
    }
    return components.join('/');
};
exports.getInternalPathFromExternal = getInternalPathFromExternal;
exports.filterableGraphqlTypes = Object.entries(xtrem_shared_1.filterGraphqlMapping).reduce((acc, [k, v]) => {
    if (v !== undefined) {
        acc.push(k);
    }
    return acc;
}, []);
//# sourceMappingURL=utils.js.map