import * as React from 'react';
import type { RowDataType, TableCols } from './sort-condition-editor-types';
import type { Dict, LocalizeFunction, TreeElement } from '@sage/xtrem-shared';
import type { FlatTableProps } from '../flat-table/flat-table-types';
export interface PropertyCellRendererProps<ListPropertyItem extends TreeElement> {
    localize: LocalizeFunction;
    onCellChange: <P extends FlatTableProps<TableCols<ListPropertyItem>>['columns'][number]['id']>(args: {
        columnId: P;
        rowId: string;
        value: FlatTableProps<TableCols<ListPropertyItem>>['data'][number][P];
    }) => void;
    rowData: RowDataType<ListPropertyItem>;
    allData: Array<RowDataType<ListPropertyItem>>;
    properties: Dict<ListPropertyItem>;
    getPropertySubtitle?: (property: ListPropertyItem) => string | null;
    readOnly?: boolean;
}
export declare function PropertyCellRenderer<ListPropertyItem extends TreeElement>({ rowData, localize, onCellChange, properties, allData, getPropertySubtitle, readOnly, }: PropertyCellRendererProps<ListPropertyItem>): React.ReactElement;
//# sourceMappingURL=property-cell-renderer.d.ts.map