"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ParameterRangeValueInput = void 0;
const react_1 = __importDefault(require("react"));
const parameter_value_input_1 = require("./parameter-value-input");
function ParameterRangeValueInput(props) {
    const { onCellChange, rowData, columnId } = props;
    const valueComponents = rowData[columnId]?.split('~');
    const [fromValue, setFromValue] = react_1.default.useState(valueComponents?.[0] || null);
    const [toValue, setToValue] = react_1.default.useState(valueComponents?.[1] || null);
    const onFromChange = react_1.default.useCallback(({ value }) => {
        setFromValue(value);
    }, []);
    const onToChange = react_1.default.useCallback(({ value }) => {
        setToValue(value);
    }, []);
    react_1.default.useEffect(() => {
        const value = rowData[columnId];
        if (!value) {
            setFromValue(null);
            setToValue(null);
            return;
        }
        const components = value.split('~');
        setFromValue(components[0] || null);
        setToValue(components[1] || null);
    }, [rowData, columnId]);
    react_1.default.useEffect(() => {
        const currentValue = rowData[columnId];
        if (!fromValue || !toValue) {
            if (currentValue) {
                onCellChange({
                    columnId,
                    rowId: rowData._id,
                    value: null,
                    rowData,
                });
            }
            return;
        }
        const newValue = `${fromValue}~${toValue}`;
        if (currentValue !== newValue) {
            onCellChange({
                columnId,
                rowId: rowData._id,
                value: newValue,
                rowData,
            });
        }
    }, [fromValue, toValue, onCellChange, columnId, rowData]);
    return (react_1.default.createElement("div", { className: "e-widget-editor-range-filter-parameter" },
        react_1.default.createElement(parameter_value_input_1.ParameterValueInput, { key: "from", ...props, controlledValue: fromValue, onCellChange: onFromChange, "data-testid": "e-widget-editor-filter-value-from" }),
        react_1.default.createElement(parameter_value_input_1.ParameterValueInput, { key: "to", ...props, controlledValue: toValue, onCellChange: onToChange, "data-testid": "e-widget-editor-filter-value-to" })));
}
exports.ParameterRangeValueInput = ParameterRangeValueInput;
//# sourceMappingURL=parameter-range-value-input.js.map