"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useCustomCompareMemo = void 0;
const react_1 = require("react");
/**
 * Like useMemo but uses provided comparator function to validate dependency changes.
 *
 * @param factory useMemo factory function
 * @param deps useMemo dependency list
 * @param comparator function to validate dependency changes
 * @returns useMemo result
 */
const useCustomCompareMemo = (factory, deps, comparator) => {
    const dependencies = (0, react_1.useRef)();
    if (dependencies.current === undefined || !comparator(dependencies.current, deps)) {
        dependencies.current = deps;
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
    return (0, react_1.useMemo)(factory, dependencies.current);
};
exports.useCustomCompareMemo = useCustomCompareMemo;
//# sourceMappingURL=use-custom-compare-memo.js.map