"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FlatTable = void 0;
const react_1 = __importDefault(require("react"));
const flat_table_1 = require("carbon-react/esm/components/flat-table");
const button_minor_1 = __importDefault(require("carbon-react/esm/components/button-minor"));
const box_1 = __importDefault(require("carbon-react/esm/components/box"));
const typography_1 = __importDefault(require("carbon-react/esm/components/typography"));
const lodash_1 = require("lodash");
// eslint-disable-next-line @typescript-eslint/explicit-function-return-type
function FlatTable({ actionsText = 'Actions', addButtonText = 'Add item', canAddNewLines = false, canDrag = false, canRemoveLines = false, columns, data, emptyStateText = 'No data to display', extraData, getRowProps, isAddButtonHidden = false, maxLines, onRowAdded = lodash_1.noop, onRowDrag = lodash_1.noop, onRowRemoved = lodash_1.noop, ...flatTableProps }) {
    const colDefs = react_1.default.useMemo(() => {
        return columns.filter(column => !column.isHidden);
    }, [columns]);
    const renderRows = react_1.default.useCallback(() => {
        return data.length === 0 ? (react_1.default.createElement(flat_table_1.FlatTableRow, null,
            react_1.default.createElement(flat_table_1.FlatTableCell, { colspan: colDefs.length },
                react_1.default.createElement(box_1.default, { paddingY: 80, gap: 1, display: "flex", flexDirection: "column", alignItems: "center", justifyContent: "center" },
                    react_1.default.createElement("div", { className: "e-flat-table-placeholder" },
                        react_1.default.createElement(typography_1.default, { color: "--colorsUtilityMajor100", lineHeight: "30px", variant: "h3" }, emptyStateText)),
                    !isAddButtonHidden && (react_1.default.createElement(button_minor_1.default, { mt: 2, iconType: "add", onClick: onRowAdded, "data-testid": "add-item-button" }, addButtonText)))))) : (data.map((row, rowIndex, allData) => {
            const rowWithId = row;
            const cols = colDefs.map(({ header, id, cellRenderer: CellRenderer, isHidden: _, ...cellProps }) => {
                const renderedItem = CellRenderer ? (react_1.default.createElement(CellRenderer, { rowData: row, rowIndex: rowIndex, data: allData, extraData: extraData })) : ((0, lodash_1.get)(row, id, ''));
                const CellComponent = header.isSticky ? flat_table_1.FlatTableRowHeader : flat_table_1.FlatTableCell;
                return (react_1.default.createElement(CellComponent, { key: `${rowWithId._id}-${id}`, width: header.width, truncate: true, ...cellProps }, renderedItem));
            });
            const rowProps = getRowProps?.({ row, data: allData, rowIndex });
            return (react_1.default.createElement(flat_table_1.FlatTableRow, { key: rowWithId._id, id: rowWithId._id, "data-testid": rowWithId._id, ...rowProps }, (canAddNewLines || canRemoveLines) && data.length > 0 ? (react_1.default.createElement(react_1.default.Fragment, null,
                cols,
                react_1.default.createElement(flat_table_1.FlatTableCell, { key: "__actions" },
                    react_1.default.createElement("div", { className: "e-flat-table-actions-container" },
                        react_1.default.createElement(button_minor_1.default, { buttonType: "secondary", iconType: "remove", "aria-label": "Remove", size: "small", marginRight: 2, onClick: () => onRowRemoved(row), "data-testid": "flat-table-remove-button" }),
                        canAddNewLines &&
                            rowIndex === data.length - 1 &&
                            (!maxLines || data.length < maxLines) && (react_1.default.createElement(button_minor_1.default, { buttonType: "secondary", iconType: "add", "aria-label": "Add", size: "small", onClick: onRowAdded, "data-testid": "flat-table-add-button" })))))) : (cols)));
        }));
    }, [
        addButtonText,
        canAddNewLines,
        canRemoveLines,
        colDefs,
        data,
        emptyStateText,
        extraData,
        getRowProps,
        isAddButtonHidden,
        maxLines,
        onRowAdded,
        onRowRemoved,
    ]);
    const hasDrag = react_1.default.useMemo(() => canDrag && data.length > 0, [canDrag, data.length]);
    const hasData = data.length !== 0;
    const tableProps = { ...flatTableProps };
    tableProps.className = hasData ? 'e-flat-table-has-data' : 'e-flat-table-empty';
    return (react_1.default.createElement(flat_table_1.FlatTable, { overflowX: "auto", width: "100%", ...tableProps },
        react_1.default.createElement(flat_table_1.FlatTableHead, null,
            react_1.default.createElement(flat_table_1.FlatTableRow, null,
                hasDrag && react_1.default.createElement(flat_table_1.FlatTableHeader, { width: 40 }),
                colDefs.map(({ header: { name: headername, isSticky, ...headerProps }, id: columnId }) => {
                    const HeaderComponent = isSticky ? flat_table_1.FlatTableRowHeader : flat_table_1.FlatTableHeader;
                    return (react_1.default.createElement(HeaderComponent, { key: columnId, ...headerProps, truncate: true }, headername));
                }),
                (canAddNewLines || canRemoveLines) && data.length > 0 && (react_1.default.createElement(flat_table_1.FlatTableHeader, { key: "__actions", width: 120 }, actionsText)))),
        hasDrag ? (
        // @ts-expect-error IDs can also be strings
        react_1.default.createElement(flat_table_1.FlatTableBodyDraggable, { getOrder: onRowDrag }, renderRows())) : (react_1.default.createElement(flat_table_1.FlatTableBody, null, renderRows()))));
}
exports.FlatTable = FlatTable;
FlatTable.displayName = 'FlatTable';
//# sourceMappingURL=flat-table.js.map