import React from 'react';
import type { Validations, DefaultFilterCols, OnCellChange, FilterParameter, ParameterHandlingMode } from './filter-table-types';
import type { ColDef, FlatTableProps, UnrestrictedTableCols } from '../flat-table/flat-table-types';
import type { LocalizeLocale, LocalizeFunction } from '@sage/xtrem-shared';
import type { CarbonLocaleType } from '../types';
export interface FilterTableValueColumnProps<Cols extends ColDef[] = [], E = unknown> {
    carbonLocale: CarbonLocaleType;
    errors: Validations<Cols>;
    isDisabled?: boolean;
    locale: LocalizeLocale;
    localize: LocalizeFunction;
    localizeEnumMember: (enumFullPathName: string, memberName: string) => string;
    node?: string;
    onCellChange: OnCellChange<Cols, E>;
    parameterMode?: ParameterHandlingMode;
    parameters?: Array<FilterParameter>;
    rowData: FlatTableProps<UnrestrictedTableCols<DefaultFilterCols, Cols>, E>['data'][number];
}
export declare function FilterTableValueColumn<Cols extends ColDef[] = [], E = unknown>(props: FilterTableValueColumnProps<Cols, E>): React.ReactElement | null;
export declare const FilterTableValueColumnMemo: React.MemoExoticComponent<typeof FilterTableValueColumn>;
//# sourceMappingURL=filter-table-value-column.d.ts.map