/// <reference types="react" />
/// <reference types="lodash" />
import { type Dict, type LocalizeFunction } from '@sage/xtrem-shared';
import type { ColDef, FlatTableProps, UnrestrictedTableCols } from '../flat-table/flat-table-types';
import type { DefaultPropertyType } from '../types';
import type { DefaultFilterCols, FilterTableAction, FilterTableProps, FilterTableState, ParameterHandlingMode, Validations } from './filter-table-types';
export declare const SplitBox: import("styled-components").StyledComponent<import("react").ForwardRefExoticComponent<import("carbon-react/esm/components/box").BoxProps & import("react").RefAttributes<HTMLDivElement>>, any, {}, never>;
export declare const isCompleteRow: <Cols extends ColDef[] = [], E = unknown>(row: FlatTableProps<UnrestrictedTableCols<DefaultFilterCols, Cols>, E>['data'][number], validations: Validations<Cols>, parameterMode?: ParameterHandlingMode) => boolean;
export declare const mapFilterToEditorRow: (<Cols extends ColDef[] = [], P extends DefaultPropertyType = DefaultPropertyType, E = unknown>({ value, selectedProperties, }: {
    value: NonNullable<FilterTableProps['value']>;
    selectedProperties?: Dict<P>;
}) => FlatTableProps<UnrestrictedTableCols<DefaultFilterCols, Cols>, E>['data']) & import("lodash").MemoizedFunction;
export declare function filterTableReducer<Cols extends ColDef[] = [], P extends DefaultPropertyType = DefaultPropertyType, E = unknown>(): (localize: LocalizeFunction) => (state: FilterTableState<Cols, E>, action: FilterTableAction<Cols, P, E>) => FilterTableState<Cols, E>;
export declare function getPropertyParentNode({ labelPath, nodeNames, node, }: {
    labelPath?: string;
    nodeNames: Dict<string>;
    node?: string;
}): string;
//# sourceMappingURL=filter-table-utils.d.ts.map