import React from 'react';
import type { DefaultFilterCols, OnCellChange } from './filter-table-types';
import type { ColDef, FlatTableProps, UnrestrictedTableCols } from '../flat-table/flat-table-types';
import type { Dict, LocalizeFunction } from '@sage/xtrem-shared';
import type { DefaultPropertyType } from '../types';
export interface FilterTablePropertyColumnProps<Cols extends ColDef[] = [], P extends DefaultPropertyType = DefaultPropertyType, E = unknown> {
    filterableProperties: P[];
    isDisabled?: boolean;
    localize: LocalizeFunction;
    node?: string;
    nodeNames: Dict<string>;
    onCellChange: OnCellChange<Cols, E>;
    rowData: FlatTableProps<UnrestrictedTableCols<DefaultFilterCols, Cols>, E>['data'][number];
}
export declare function FilterTablePropertyColumn<Cols extends ColDef[] = [], P extends DefaultPropertyType = DefaultPropertyType, E = unknown>({ localize, onCellChange, rowData, filterableProperties, nodeNames, node, isDisabled, }: FilterTablePropertyColumnProps<Cols, P, E>): React.ReactElement;
//# sourceMappingURL=filter-table-property-column.d.ts.map