"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FilterTableParameterColumnMemo = exports.FilterTableParameterColumn = void 0;
const react_1 = __importDefault(require("react"));
const switch_1 = __importDefault(require("carbon-react/esm/components/switch"));
function FilterTableParameterColumn({ isDisabled, onCellChange, rowData, }) {
    return (react_1.default.createElement("div", { className: "e-filter-table-parameter-switch" },
        react_1.default.createElement(switch_1.default, { "data-testid": `e-widget-editor-filter-parameter-${rowData._id}`, size: "small", name: "parameter", disabled: isDisabled, onChange: (e) => {
                onCellChange({
                    columnId: 'parameter',
                    rowData,
                    rowId: rowData._id,
                    value: e.target.checked,
                });
                // reset filter value
                onCellChange({
                    columnId: 'filterValue',
                    rowData,
                    rowId: rowData._id,
                    value: undefined,
                });
            }, checked: rowData.parameter || false })));
}
exports.FilterTableParameterColumn = FilterTableParameterColumn;
exports.FilterTableParameterColumnMemo = react_1.default.memo(FilterTableParameterColumn);
exports.FilterTableParameterColumnMemo.displayName = 'FilterTableParameterColumnMemo';
//# sourceMappingURL=filter-table-parameter-column.js.map