"use strict";
/* eslint-disable react/no-unstable-nested-components */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TableContentWithGroups = void 0;
const React = __importStar(require("react"));
const xtrem_shared_1 = require("@sage/xtrem-shared");
const select_1 = require("carbon-react/esm/components/select");
const lodash_1 = require("lodash");
const flat_table_1 = require("../flat-table/flat-table");
const responsive_grid_1 = require("../responsive-grid/responsive-grid");
const content_table_1 = require("./content-table");
const content_table_types_1 = require("./content-table-types");
const content_table_utils_1 = require("./content-table-utils");
const message_1 = __importDefault(require("carbon-react/esm/components/message"));
function TableContentWithGroups({ selectedItems = {}, onChange, localize, value, isDisabled = false, isAddButtonHidden = false, isPropertySelectionDisabled = false, onDisplayNotification, setGroupOrderError, }) {
    // TODO: XT-54876 pass node & nodeNames to component
    const nodeNames = {};
    const node = '';
    const [groupOrderValidation, setGroupOrderValidation] = React.useState({
        isValid: true,
        invalidFields: [],
    });
    const selectedProperties = React.useMemo(() => {
        const basicTypes = Object.values(xtrem_shared_1.GraphQLTypes);
        return Object.keys(selectedItems).reduce((acc, curr) => {
            if (basicTypes.includes(selectedItems[curr].data?.type) ||
                selectedItems[curr].data?.kind === 'ENUM') {
                acc[curr] = selectedItems[curr];
            }
            return acc;
        }, {});
    }, [selectedItems]);
    const displayGroupErrorMessage = React.useCallback(() => {
        if (onDisplayNotification) {
            onDisplayNotification(localize('@sage/xtrem-ui-components/disallowed-group-assignment', 'Non-sortable properties cannot be the first items in the group. Select other properties.'), 'error');
        }
    }, [localize, onDisplayNotification]);
    const { addButtonText, canAddNewLines, canDrag, columns, counter, data, onCellChange, onRowAdded, onRowDrag: defaultOnRowDrag, onRowRemoved, validations, setOrderedIds, } = (0, content_table_1.useContentTable)({
        isPropertySelectionDisabled,
        value,
        localize,
        node,
        nodeNames,
        onChange,
        selectedProperties,
        contentType: content_table_types_1.CONTENT_TYPES.DOCUMENT_EDITOR,
    });
    const groupColumn = React.useMemo(() => {
        const allFieldsInvalid = (0, content_table_utils_1.areAllPropertiesNonSortable)(data);
        if (allFieldsInvalid) {
            return {
                id: 'group',
                header: {
                    name: '',
                },
                cellRenderer: () => null,
            };
        }
        return {
            id: 'group',
            header: {
                name: localize('@sage/xtrem-ui-components/group', 'Group'),
                width: 150,
            },
            // eslint-disable-next-line @typescript-eslint/explicit-function-return-type
            cellRenderer: params => {
                return (React.createElement(select_1.FilterableSelect, { openOnFocus: true, "data-testid": `e-widget-editor-content-group-${params.rowData._id}`, onChange: ({ target: { value: groupValue } }) => {
                        const newValue = Number(groupValue);
                        const { success, data: orderedData } = (0, xtrem_shared_1.arrayMovePreservingOrder)({
                            data: params.data,
                            fromIndex: params.rowIndex,
                            toValue: newValue,
                            orderByKey: 'group',
                        });
                        if (success) {
                            onCellChange({
                                columnId: 'group',
                                rowId: params.rowData._id,
                                value: newValue,
                                rowData: { ...params.rowData, group: newValue },
                            });
                            setOrderedIds({
                                newOrderedIds: orderedData.map(d => d.path),
                                id: 'path',
                                enforceContiguous: 'group',
                            });
                            setGroupOrderValidation({ isValid: true });
                            if (setGroupOrderError) {
                                setGroupOrderError(false);
                            }
                        }
                        else {
                            displayGroupErrorMessage();
                        }
                    }, placeholder: localize('@sage/xtrem-ui-components/select-value-placeholder', 'Select value...'), size: "small", value: (0, lodash_1.isNil)(params.rowData.group) ? '0' : String(params.rowData.group) }, (0, lodash_1.range)(0, ((0, lodash_1.max)(params.data.map(d => d.group)) ?? 0) + 2).map(index => {
                    const actualIndex = index + 1;
                    const text = localize('@sage/xtrem-ui-components/group-number', 'Group {{groupNumber}}', {
                        groupNumber: actualIndex,
                    });
                    return (React.createElement(select_1.Option, { key: index, text: text, value: String(index) }, text));
                })));
            },
        };
    }, [data, localize, onCellChange, setOrderedIds, setGroupOrderError, displayGroupErrorMessage]);
    const operationColumn = React.useMemo(() => ({
        id: 'operation',
        header: {
            name: localize('@sage/xtrem-ui-components/operation', 'Operation'),
            width: 200,
        },
        // eslint-disable-next-line @typescript-eslint/explicit-function-return-type
        cellRenderer: params => {
            const availableAggregations = params.rowData.property
                ? (xtrem_shared_1.aggregationsGraphqlMapping[params.rowData.property.data.type] ?? [])
                : [];
            return availableAggregations.length === 0 ? null : (React.createElement(select_1.FilterableSelect, { openOnFocus: true, "data-testid": `e-widget-editor-content-operation-${params.rowData._id}`, onChange: ({ target: { value: operationValue } }) => {
                    const newOperationValue = operationValue === '' ? 'NONE' : operationValue;
                    onCellChange({
                        columnId: 'operation',
                        rowId: params.rowData._id,
                        value: newOperationValue,
                        rowData: params.rowData,
                    });
                    if ((0, lodash_1.isNil)(params.rowData.sorting)) {
                        onCellChange({
                            columnId: 'sorting',
                            rowId: params.rowData._id,
                            value: xtrem_shared_1.Sortings.ascending,
                            rowData: params.rowData,
                        });
                    }
                }, placeholder: localize('@sage/xtrem-ui-components/select-value-placeholder', 'Select value...'), size: "small", value: (0, lodash_1.isNil)(params.rowData.operation) ? '' : String(params.rowData.operation) }, availableAggregations.map((aggregation) => {
                const text = (0, xtrem_shared_1.aggregationTranslations)(localize)[aggregation];
                return (React.createElement(select_1.Option, { key: aggregation, text: text, value: aggregation }, text));
            })));
        },
    }), [onCellChange, localize]);
    const sortingColumn = React.useMemo(() => ({
        id: 'sorting',
        header: {
            name: localize('@sage/xtrem-ui-components/sorting', 'Sorting'),
            width: 150,
        },
        // eslint-disable-next-line @typescript-eslint/explicit-function-return-type
        cellRenderer: params => {
            const availableSortings = params.rowData.property
                ? (xtrem_shared_1.sortingGraphqlMapping[params.rowData.property.data.type] ?? [])
                : [];
            if (!params.rowData.path ||
                !selectedItems[params.rowData.path]?.data?.canFilter ||
                availableSortings.length === 0) {
                return null;
            }
            return (React.createElement(select_1.FilterableSelect, { openOnFocus: true, "data-testid": `e-widget-editor-content-sorting-${params.rowData._id}`, onChange: ({ target: { value: sortingValue } }) => {
                    const newSortingValue = sortingValue === '' ? xtrem_shared_1.Sortings.ascending : sortingValue;
                    onCellChange({
                        columnId: 'sorting',
                        rowId: params.rowData._id,
                        value: newSortingValue,
                        rowData: params.rowData,
                    });
                }, placeholder: localize('@sage/xtrem-ui-components/select-value-placeholder', 'Select value...'), size: "small", value: (0, lodash_1.isNil)(params.rowData.sorting) ? '' : String(params.rowData.sorting) }, availableSortings.map((sorting) => {
                const text = (0, xtrem_shared_1.sortingTranslations)(localize)[sorting];
                return (React.createElement(select_1.Option, { key: sorting, text: text, value: sorting }, text));
            })));
        },
    }), [localize, selectedItems, onCellChange]);
    const onRowDrag = React.useCallback(newOrderedIds => {
        const orderedData = (0, lodash_1.sortBy)(data, d => (0, lodash_1.findIndex)(newOrderedIds, element => d._id === element));
        const newData = (0, content_table_utils_1.enforceContiguousOrder)({
            orderedData,
            key: 'group',
        });
        const { isValid } = (0, content_table_utils_1.checkValidGroupOrder)({ data: newData, enforceContiguous: 'group' });
        if (isValid) {
            setOrderedIds({
                newOrderedIds: newData.map(d => d.path),
                id: 'path',
                enforceContiguous: 'group',
            });
            setGroupOrderValidation({ isValid });
            if (setGroupOrderError) {
                setGroupOrderError(false);
            }
        }
        else {
            setOrderedIds({
                newOrderedIds: data.map(d => d.path),
                id: 'path',
                enforceContiguous: 'group',
            });
            displayGroupErrorMessage();
        }
    }, [data, setGroupOrderError, setOrderedIds, displayGroupErrorMessage]);
    const getRowProps = React.useCallback(({ row, data: tableData, rowIndex }) => {
        const isEven = (row.group ?? 0) % 2 === 0;
        return {
            bgColor: isEven ? undefined : '--colorsUtilityMajor100',
            horizontalBorderColor: isEven ? undefined : '--colorsUtilityYang100',
            ...((tableData[rowIndex + 1]?.group ?? row.group) !== row.group
                ? {
                    horizontalBorderSize: 'medium',
                    horizontalBorderColor: '--colorsUtilityMajor400',
                }
                : {}),
        };
    }, []);
    const propertyColumn = React.useMemo(() => columns[0], [columns]);
    const titleColumn = React.useMemo(() => columns[1], [columns]);
    const pathColumn = React.useMemo(() => columns[5], [columns]);
    const flatTableColumns = React.useMemo(() => [propertyColumn, titleColumn, groupColumn, operationColumn, sortingColumn, pathColumn], [groupColumn, operationColumn, pathColumn, propertyColumn, sortingColumn, titleColumn]);
    const hasDefaultTitles = React.useRef(false);
    React.useEffect(() => {
        if (hasDefaultTitles.current || !data.length) {
            return;
        }
        hasDefaultTitles.current = true;
        data.forEach(row => {
            onCellChange({ columnId: 'title', rowData: row, rowId: row._id, value: row.title });
        });
    }, [data, onCellChange]);
    React.useEffect(() => {
        const { isValid, invalidFields } = (0, content_table_utils_1.checkValidGroupOrder)({ data, enforceContiguous: 'group' });
        setGroupOrderValidation({ isValid, invalidFields });
        if (setGroupOrderError) {
            setGroupOrderError(!isValid);
        }
    }, [data, setGroupOrderError]);
    const extraData = React.useMemo(() => ({ validations }), [validations]);
    const actionsText = React.useMemo(() => localize('@sage/xtrem-ui-components/actions', 'Actions'), [localize]);
    const emptyStateText = React.useMemo(() => Object.keys(selectedProperties).length === 0
        ? localize('@sage/xtrem-ui-components/widget-editor-no-selectable-properties', 'Select a property to add a value.')
        : undefined, [localize, selectedProperties]);
    const handleRowAdded = React.useCallback(() => {
        // add row to the last group
        onRowAdded?.({ group: data[data.length - 1]?.group ?? 0 });
        setOrderedIds({
            newOrderedIds: [...data.map(d => d._id), String(counter + 1)],
            id: '_id',
            enforceContiguous: 'group',
        });
    }, [onRowAdded, data, counter, setOrderedIds]);
    return (React.createElement(responsive_grid_1.GridRow, { columns: 8, gutter: 16, margin: 0, verticalMargin: 0, className: "document-editor-content-table" },
        React.createElement(responsive_grid_1.GridColumn, { columnSpan: 8 },
            !groupOrderValidation.isValid && (React.createElement("div", { "data-testid": "e-widget-editor-group-order-error-message" },
                React.createElement(message_1.default, { variant: "error", mb: "16px" }, !groupOrderValidation.isValid && (React.createElement("div", null, localize('@sage/xtrem-ui-components/disallowed-group-assignment-list-properties', `The following properties: ${groupOrderValidation.invalidFields ||
                    [].map(fieldName => `"${fieldName}"`).join(', ')}, are non-sortable and cannot be the first items in the group.`)))))),
            React.createElement(flat_table_1.FlatTable, { actionsText: actionsText, addButtonText: addButtonText, canAddNewLines: !isDisabled && canAddNewLines, canDrag: canDrag, canRemoveLines: !isDisabled, columns: flatTableColumns, data: data, emptyStateText: emptyStateText, extraData: extraData, isAddButtonHidden: isAddButtonHidden, getRowProps: getRowProps, onRowAdded: handleRowAdded, onRowDrag: onRowDrag, onRowRemoved: onRowRemoved }))));
}
exports.TableContentWithGroups = TableContentWithGroups;
//# sourceMappingURL=content-table-with-groups.js.map