import * as React from 'react';
import type { AggregationOptions, SortingOptions, Dict, LocalizeFunction, TreeElement } from '@sage/xtrem-shared';
import type { FlatTableProps, UnrestrictedTableCols } from '../flat-table/flat-table-types';
import type { DataModelProperty } from '../types';
import type { ContentTableProps, DefaultContentTableCols } from './content-table-types';
import type { ToastProps } from 'carbon-react/esm/components/toast';
interface TreeElementWithGroups<T extends any = DataModelProperty> extends TreeElement<T> {
    group?: number;
    operation?: AggregationOptions['operation'];
    sorting?: SortingOptions;
    title?: string;
}
type AdditionalContentColumns = [
    {
        id: 'group';
        type: number;
    },
    {
        id: 'operation';
        type?: AggregationOptions['operation'];
    },
    {
        id: 'sorting';
        type?: SortingOptions;
    }
];
export interface TableContentWithGroupsProps<P extends TreeElementWithGroups = TreeElementWithGroups, E = unknown> {
    isAddButtonHidden?: boolean;
    isDisabled?: boolean;
    isPropertySelectionDisabled?: boolean;
    localize: LocalizeFunction;
    onChange: ContentTableProps<AdditionalContentColumns, P, E>['onChange'];
    selectedItems?: Dict<P>;
    value: Omit<FlatTableProps<UnrestrictedTableCols<DefaultContentTableCols, AdditionalContentColumns, false>, E>['data'][number], '_id'>[];
    onDisplayNotification?: (content: string, type: ToastProps['variant']) => void;
    setGroupOrderError?: (value: boolean) => void;
}
export declare function TableContentWithGroups<P extends TreeElementWithGroups = TreeElementWithGroups, E = unknown>({ selectedItems, onChange, localize, value, isDisabled, isAddButtonHidden, isPropertySelectionDisabled, onDisplayNotification, setGroupOrderError, }: TableContentWithGroupsProps<P, E>): React.ReactElement;
export {};
//# sourceMappingURL=content-table-with-groups.d.ts.map