"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ContentTablePresentationColumn = void 0;
const xtrem_shared_1 = require("@sage/xtrem-shared");
const select_1 = require("carbon-react/esm/components/select");
const typography_1 = __importDefault(require("carbon-react/esm/components/typography"));
const react_1 = __importDefault(require("react"));
const content_table_types_1 = require("./content-table-types");
const content_table_utils_1 = require("./content-table-utils");
function ContentTablePresentationColumn({ isDisabled, localize, onCellChange, rowData, contentType, ...rest }) {
    const presentationMapping = react_1.default.useMemo(() => contentType === content_table_types_1.CONTENT_TYPES.DOCUMENT_EDITOR
        ? xtrem_shared_1.presentationEditorGraphqlMapping
        : xtrem_shared_1.presentationGraphqlMapping, [contentType]);
    if (rowData.property?.data?.type && presentationMapping[rowData.property.data.type].length === 1) {
        return (react_1.default.createElement("div", { "data-testid": `e-widget-editor-content-presentation-${rowData._id}` },
            react_1.default.createElement(typography_1.default, { variant: "p", m: 0, paddingLeft: "8px" }, (0, content_table_utils_1.presentationTranslations)(localize)[presentationMapping[rowData.property.data.type][0]])));
    }
    return (react_1.default.createElement(select_1.FilterableSelect, { disabled: !rowData.property || isDisabled, openOnFocus: true, "data-testid": `e-widget-editor-content-presentation-${rowData._id}`, 
        // @ts-expect-error "onChange" is actually triggered with { target: { value: GridNestedFieldTypes } }
        onChange: ({ target: { value } }) => {
            onCellChange({ columnId: 'presentation', rowId: rowData._id, value, rowData });
        }, placeholder: localize('@sage/xtrem-ui-components/select', 'Select...'), size: "small", value: rowData.presentation ?? '', ...rest }, (rowData.property?.data?.type ? presentationMapping[rowData.property.data.type] : []).map((p) => (react_1.default.createElement(select_1.Option, { text: (0, content_table_utils_1.presentationTranslations)(localize)[p], value: p, key: p })))));
}
exports.ContentTablePresentationColumn = ContentTablePresentationColumn;
//# sourceMappingURL=content-table-presentation-column.js.map