import type { LocalizeFunction } from '@sage/xtrem-shared';
import { FilterableSelect } from 'carbon-react/esm/components/select';
import React from 'react';
import type { ColDef, FlatTableProps, UnrestrictedTableCols } from '../flat-table/flat-table-types';
import { CONTENT_TYPES, type DefaultContentTableCols, type OnCellChange } from './content-table-types';
export interface ContentTablePresentationColumnProps<Cols extends ColDef[] = [], E = unknown> extends Partial<React.ComponentProps<typeof FilterableSelect>> {
    isDisabled?: boolean;
    localize: LocalizeFunction;
    onCellChange: OnCellChange<Cols, E>;
    rowData: FlatTableProps<UnrestrictedTableCols<DefaultContentTableCols, Cols>, E>['data'][number];
    contentType?: CONTENT_TYPES;
}
export declare function ContentTablePresentationColumn<Cols extends ColDef[] = [], E = unknown>({ isDisabled, localize, onCellChange, rowData, contentType, ...rest }: ContentTablePresentationColumnProps<Cols, E>): React.ReactElement;
//# sourceMappingURL=content-table-presentation-column.d.ts.map