import React from 'react';
import type { DefaultConditionEditorCols, OnCellChange, FilterParameter } from './condition-editor-table-types';
import type { ColDef, FlatTableProps, UnrestrictedTableCols } from '../flat-table/flat-table-types';
import type { LocalizeFunction } from '@sage/xtrem-shared';
export interface ValueTypeColumnProps<Cols extends ColDef[] = [], E = unknown> {
    isDisabled?: boolean;
    onCellChange: OnCellChange<Cols, E>;
    rowData: FlatTableProps<UnrestrictedTableCols<DefaultConditionEditorCols, Cols>, E>['data'][number];
    localize: LocalizeFunction;
    columnId: 'valueType1' | 'valueType2';
    parameters?: FilterParameter[];
}
export declare function ValueTypeColumn<Cols extends ColDef[] = [], E = unknown>({ isDisabled, onCellChange, rowData, localize, columnId, parameters, }: ValueTypeColumnProps<Cols, E>): React.ReactElement;
//# sourceMappingURL=value-type-column.d.ts.map