// From file: /agent/_work/1/s/platform/back-end/xtrem-ts-to-sql/build/index.d.ts
declare module '@sage/xtrem-ts-to-sql/index' {
	export * from '@sage/xtrem-ts-to-sql/lib/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-ts-to-sql/build/lib/walker.d.ts
declare module '@sage/xtrem-ts-to-sql/lib/walker' {
	import { Resolver } from '@sage/xtrem-ts-to-sql/lib/resolver';
	import { Alias, BasicConversionResult, ConverterFactory, ConverterOptions, ConverterProperty, GenericConversionResult, Join, JoinComponent } from '@sage/xtrem-ts-to-sql/lib/types';
	interface JoinOptions {
	    withTenantId: boolean;
	    isNullable: boolean;
	}
	class VariableScope {
	    private readonly parent;
	    private readonly variables;
	    constructor(parent?: VariableScope | null);
	    set(name: string, value: BasicConversionResult): void;
	    peekVariable(name: string): BasicConversionResult | undefined;
	    resolve(name: string): BasicConversionResult;
	    push(): VariableScope;
	    pop(): VariableScope;
	}
	export class Walker<ContextT, FactoryT extends ConverterFactory, PropertyT extends ConverterProperty> {
	    protected context: ContextT;
	    protected rootFactory: FactoryT;
	    protected resolver: Resolver<ContextT, FactoryT, PropertyT>;
	    readonly options: ConverterOptions;
	    constructor(context: ContextT, rootFactory: FactoryT, resolver: Resolver<ContextT, FactoryT, PropertyT>, options: ConverterOptions);
	    protected get scopeAlias(): Alias;
	    protected set scopeAlias(alias: Alias);
	    get results(): Map<string, GenericConversionResult>;
	    get aliases(): Alias[];
	    get variableScope(): VariableScope;
	    get maxSubQueryDepth(): number;
	    pushVariableScope(): void;
	    popVariableScope(): void;
	    aliasIndex: number;
	    /** Sequence number for unique paths */
	    pathSequence: number;
	    readonly allTableNames: string[];
	    private readonly joins;
	    private readonly thisResults;
	    /**
	     * Generates a unique path.
	     * @param parentPath - The parent path to generate the unique path from (for debugging purposes).
	     * @returns The unique path.
	     */
	    getUniquePath(parentPath: string): string;
	    pushAlias(alias: Alias): void;
	    protected static createJoin(left: JoinComponent, right: JoinComponent, options: JoinOptions): Join;
	    protected createCollectionJoin(resolved: GenericConversionResult, reverseResolved: GenericConversionResult | null): void;
	    protected createReferenceJoin(resolved: GenericConversionResult<FactoryT, PropertyT>, reverseResolved: GenericConversionResult<FactoryT, PropertyT> | null): void;
	    makeAliasAndJoin(resolved: GenericConversionResult): void;
	    private _walk;
	    protected walk(parent: GenericConversionResult, name: string, overrides?: {
	        factory: FactoryT;
	    }): GenericConversionResult<FactoryT, PropertyT>;
	    private static formatJoins;
	    getTableAliases(): string;
	    withSubQueryScope<T extends {}>(body: () => T, getJoinCondition?: () => string): T & {
	        aliases: string;
	        joinCondition: string;
	        innerAlias: Alias;
	    };
	    private pushAliasAndJoin;
	    private walkToSuper;
	    convertThisExpression(isMemberOf?: boolean): GenericConversionResult<FactoryT, PropertyT>;
	    withThisResultScope<T>(result: GenericConversionResult<FactoryT, PropertyT>, body: () => T): T;
	    private static join;
	    static and(clauses: (string | undefined)[]): string;
	    static or(clauses: (string | undefined)[]): string;
	    /**
	     * Default maximum depth of sub queries.
	     *
	     * Default value of 2 will limit us to 1 main query with 2 nested sub queries, for example a query on document
	     * with a filter like `document.every(line => line.stockDetails.some(stock => ...))`
	     *
	     * This is sufficient for our current `getValue` rules but it may limit filters in GraphQL API queries.
	     * We could increase it we get requests for it but we should be careful as it could lead to performance issues.
	     * And better start with a low value and increase it if needed, after assessing the impact.
	     */
	    private static readonly defaultMaxSubQueryDepth;
	}
	export {};
	//# sourceMappingURL=walker.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-ts-to-sql/build/lib/types.d.ts
declare module '@sage/xtrem-ts-to-sql/lib/types' {
	export function getColumnName(s: string): string;
	export const getTableName: typeof getColumnName;
	export type ConversionResultType = 'boolean' | 'enum' | 'enumArray' | 'short' | 'byte' | 'integer' | 'integerRange' | 'integerArray' | 'decimalRange' | 'decimal' | 'float' | 'double' | 'string' | 'stringArray' | 'date' | 'dateRange' | 'datetimeRange' | 'time' | 'binaryStream' | 'binary' | 'textStream' | 'uuid' | 'datetime' | 'json' | 'reference' | 'referenceArray' | 'collection' | 'instance' | 'jsonReference' | 'unknown' | 'void';
	export interface ConverterFactory {
	    name: string;
	    table?: {
	        sqlTableName: string;
	    };
	    isSharedByAllTenants?: boolean;
	    baseFactory?: this;
	    tableName?: string;
	}
	export type ConverterProperty = {
	    name: string;
	    type: ConversionResultType;
	    isNullable?: boolean;
	    isStored?: boolean;
	    isLocalized?: boolean;
	};
	export interface BasicConversionResult<FactoryT extends ConverterFactory = ConverterFactory, PropertyT extends ConverterProperty = ConverterProperty> {
	    factory?: FactoryT;
	    property?: PropertyT;
	    path?: string;
	    type: ConversionResultType;
	    isNullable?: boolean;
	    sql: string;
	    extraType?: string;
	}
	export interface Alias {
	    tableName: string;
	    alias: string;
	    join?: Join;
	}
	export interface JoinComponent {
	    alias: string;
	    sqls: string[];
	}
	export interface Join {
	    left: JoinComponent;
	    right: JoinComponent;
	    condition: string;
	    isNullable: boolean;
	    lateral?: string;
	}
	export interface GenericConversionResult<FactoryT extends ConverterFactory = ConverterFactory, PropertyT extends ConverterProperty = ConverterProperty> extends BasicConversionResult<FactoryT, PropertyT> {
	    alias: string;
	    path: string;
	    parent?: GenericConversionResult<FactoryT, PropertyT>;
	    factory: FactoryT;
	    reverseReferenceName?: string;
	    isInherited?: boolean;
	    aggregationOperator?: string;
	    columnAlias?: string;
	    join?: Join;
	    collation?: string;
	    skipJoin?: boolean;
	}
	export type Dialect = 'postgres' | 'oracle' | 'sqlServer';
	export interface ConverterOptions {
	    /** The SQL dialect (postgres, oracle, sqlServer) */
	    dialect: Dialect;
	    /** Maximum subquery depth that the ts-to-sql converter accepts */
	    maxSubQueryDepth?: number;
	    /** Disables logging - used during verification of getValue / computeValue decorators */
	    quiet?: boolean;
	}
	//# sourceMappingURL=types.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-ts-to-sql/build/lib/type-converter.d.ts
declare module '@sage/xtrem-ts-to-sql/lib/type-converter' {
	import { BasicConversionResult, ConversionResultType } from '@sage/xtrem-ts-to-sql/lib/types';
	/**
	 * Converts date expressions to SQL.
	 */
	export class TypeConverter {
	    private readonly dialect;
	    constructor(dialect: string);
	    private oracleType;
	    private sqlServerType;
	    private postgresType;
	    sqlType(type: ConversionResultType): string;
	    castOracleDate: (result: BasicConversionResult, type: ConversionResultType) => BasicConversionResult;
	    isNumericType(type: ConversionResultType): boolean;
	}
	//# sourceMappingURL=type-converter.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-ts-to-sql/build/lib/resolver.d.ts
declare module '@sage/xtrem-ts-to-sql/lib/resolver' {
	import { AnyValue } from '@sage/xtrem-shared';
	import { ConverterFactory, ConverterProperty, GenericConversionResult } from '@sage/xtrem-ts-to-sql/lib/types';
	export interface Resolver<ContextT, FactoryT extends ConverterFactory, PropertyT extends ConverterProperty> {
	    resolveColumnName: (cx: ContextT, parent: GenericConversionResult<FactoryT, PropertyT>, propertyName: string) => GenericConversionResult<FactoryT, PropertyT>;
	    resolveTableName: (factory: FactoryT) => string;
	    resolveLiteral: (value: AnyValue) => string;
	}
	export class BasicResolver<ContextT, FactoryT extends ConverterFactory, PropertyT extends ConverterProperty> implements Resolver<ContextT, FactoryT, PropertyT> {
	    resolveColumnName(_cx: ContextT, parent: GenericConversionResult<FactoryT, PropertyT>, propertyName: string): GenericConversionResult<FactoryT, PropertyT>;
	    resolveTableName(factory: FactoryT): string;
	    resolveLiteral(value: AnyValue): string;
	}
	//# sourceMappingURL=resolver.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-ts-to-sql/build/lib/registry.d.ts
declare module '@sage/xtrem-ts-to-sql/lib/registry' {
	import { Dict } from '@sage/xtrem-shared';
	import * as estree from 'estree';
	import { Converter } from '@sage/xtrem-ts-to-sql/lib/converter';
	import { BasicConversionResult, GenericConversionResult } from '@sage/xtrem-ts-to-sql/lib/types';
	export interface RegistryEntry {
	    fullName: string;
	}
	export interface FunctionEntry extends RegistryEntry {
	}
	export interface ConvertibleFunctionEntry extends FunctionEntry {
	    fn: Function;
	    parameterNames: string[];
	    parsedFunction?: estree.ArrowFunctionExpression | estree.FunctionExpression;
	}
	export interface BuiltInFunctionEntry extends FunctionEntry {
	    convertExpression: (converter: Converter, expression: estree.CallExpression, args: estree.BaseExpression[], fullName: string) => BasicConversionResult;
	}
	export interface MethodEntry extends RegistryEntry {
	    convertExpression: (converter: Converter, result: GenericConversionResult, args: estree.BaseExpression[], fullName: string) => BasicConversionResult;
	}
	export interface PropertyEntry extends RegistryEntry {
	    convertExpression: (converter: Converter, result: GenericConversionResult, fullName: string) => BasicConversionResult;
	}
	class Registry {
	    private readonly functionEntries;
	    private readonly methodEntries;
	    private readonly propertyEntries;
	    memberFullName(type: string, memberName: string): string;
	    registerConvertibleFunction(entry: ConvertibleFunctionEntry): void;
	    registerBuiltInFunctions(entries: Dict<BuiltInFunctionEntry['convertExpression']>): void;
	    registerMethods(type: string, entries: Dict<MethodEntry['convertExpression']>): void;
	    registerProperties(type: string, entries: Dict<PropertyEntry['convertExpression']>): void;
	    private getEntry;
	    getFunctionEntry(fullName: string): FunctionEntry;
	    getMethodEntry(type: string, methodName: string): MethodEntry;
	    getPropertyEntry(type: string, propertyName: string): PropertyEntry;
	    registerEsLintMembers(): void;
	}
	export const registry: Registry;
	/**
	 * Registers a funct function to the TS to SQL converter.
	 *
	 * @param fullName - The full name of the SQL function.
	 * @param fn - The function to be registered.
	 * @returns The registered function.
	 */
	export function registerSqlFunction(fullName: string, fn: Function): void;
	export {};
	//# sourceMappingURL=registry.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-ts-to-sql/build/lib/protected-words.d.ts
declare module '@sage/xtrem-ts-to-sql/lib/protected-words' {
	export const protectedWords: string[];
	//# sourceMappingURL=protected-words.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-ts-to-sql/build/lib/logger.d.ts
declare module '@sage/xtrem-ts-to-sql/lib/logger' {
	import { LoggerInterface } from '@sage/xtrem-shared';
	export function setLogger(logger?: LoggerInterface): void;
	export function getLogger(): LoggerInterface;
	//# sourceMappingURL=logger.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-ts-to-sql/build/lib/index.d.ts
declare module '@sage/xtrem-ts-to-sql/lib/index' {
	export * from '@sage/xtrem-ts-to-sql/lib/conversion-error';
	export * from '@sage/xtrem-ts-to-sql/lib/converter';
	export * from '@sage/xtrem-ts-to-sql/lib/eslint-converter';
	export * from '@sage/xtrem-ts-to-sql/lib/logger';
	export * from '@sage/xtrem-ts-to-sql/lib/registry';
	export * from '@sage/xtrem-ts-to-sql/lib/resolver';
	export * from '@sage/xtrem-ts-to-sql/lib/types';
	export * from '@sage/xtrem-ts-to-sql/lib/walker';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-ts-to-sql/build/lib/eslint-converter.d.ts
declare module '@sage/xtrem-ts-to-sql/lib/eslint-converter' {
	import * as estree from 'estree';
	import { Converter } from '@sage/xtrem-ts-to-sql/lib/converter';
	import { ConvertibleFunctionEntry } from '@sage/xtrem-ts-to-sql/lib/registry';
	import { BasicConversionResult, ConversionResultType } from '@sage/xtrem-ts-to-sql/lib/types';
	/**
	 * Special converter for ESLint plugin
	 *
	 * The plugin does not have the metadata required to convert the code to SQL.
	 * So it cannot check the types. This may lead to false positives in the linting.
	 */
	export class EsLintConverter extends Converter {
	    static knownFunctions: string[];
	    dummy: void;
	    constructor(context?: any);
	    protected getCommonType(): ConversionResultType;
	    protected convertRegistryFunctionCall(callExpression: estree.CallExpression, functionEntry: ConvertibleFunctionEntry, args: (estree.Expression | estree.SpreadElement)[]): BasicConversionResult;
	}
	//# sourceMappingURL=eslint-converter.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-ts-to-sql/build/lib/converter.d.ts
declare module '@sage/xtrem-ts-to-sql/lib/converter' {
	import { AnyValue, AsyncResponse } from '@sage/xtrem-shared';
	import * as estree from 'estree';
	import { Walker } from '@sage/xtrem-ts-to-sql/lib/walker';
	import { DateConverter } from '@sage/xtrem-ts-to-sql/lib/converter-lib/date/index';
	import { ConvertibleFunctionEntry } from '@sage/xtrem-ts-to-sql/lib/registry';
	import { Resolver } from '@sage/xtrem-ts-to-sql/lib/resolver';
	import { TypeConverter } from '@sage/xtrem-ts-to-sql/lib/type-converter';
	import { BasicConversionResult, ConversionResultType, ConverterFactory, ConverterOptions, ConverterProperty, Dialect, GenericConversionResult } from '@sage/xtrem-ts-to-sql/lib/types';
	export function quote(s: string): string;
	/**
	 * Convert numeric value `val` to a SQL string.
	 * Throws an error if `val` is not a valid number.
	 */
	export function sqlNumber(slot: BasicConversionResult, val: AnyValue): string;
	export interface CastOptions<PropertyT extends ConverterProperty = ConverterProperty> {
	    type: ConversionResultType;
	    property?: PropertyT;
	}
	interface IfSqlResult {
	    statement: estree.IfStatement;
	    test: string;
	    consequent: BasicConversionResult;
	}
	export class Converter<ContextT = unknown, FactoryT extends ConverterFactory = ConverterFactory, PropertyT extends ConverterProperty = ConverterProperty> extends Walker<ContextT, FactoryT, PropertyT> {
	    readonly typeConverter: TypeConverter;
	    constructor(context: ContextT, rootFactory: FactoryT, resolver: Resolver<ContextT, FactoryT, PropertyT>, options: ConverterOptions);
	    get dialect(): Dialect;
	    get dateConverter(): DateConverter;
	    cast(result: BasicConversionResult, type: ConversionResultType): BasicConversionResult;
	    static booleanResult(sql: string): BasicConversionResult;
	    static stringResult(sql: string): BasicConversionResult;
	    convertDatePropertyResult(result: GenericConversionResult, propertyName: string): BasicConversionResult;
	    private convertMemberExpression;
	    private convertChainExpression;
	    checkResultType(expression: estree.BaseExpression, result: BasicConversionResult, expectedType: ConversionResultType): void;
	    protected getCommonType(expression: estree.BaseNode, results: BasicConversionResult[]): ConversionResultType;
	    private convertToCommonType;
	    private convertConditionalExpression;
	    private convertNullEqualityExpression;
	    protected convertBinaryExpression(expression: estree.BinaryExpression): BasicConversionResult<FactoryT, PropertyT>;
	    private convertLogicalExpression;
	    private convertUnaryExpression;
	    private convertNotArgument;
	    protected concat(strings: string[]): string;
	    private convertTemplateLiteral;
	    convertTemplateElementString(str: string): string;
	    convertTemplateElement(expression: estree.TemplateElement): BasicConversionResult;
	    convertLiteral(value: AnyValue | RegExp | bigint): BasicConversionResult;
	    /**
	     * Converts an item of an object (see convertObject) a:'aaa' -> "a = 'aaa'" / c:d -> "c = t0.d"
	     */
	    private convertPropertyAssignments;
	    /**
	     * Converts an object {a:'aaa', b:'bbb', c:d} into sth like "a='aaa', b='bbb', c=t0.d"
	     * Can be used for update ... set ... operations
	     */
	    private convertObjectAssignments;
	    convertNaryCallExpression(expression: estree.BaseCallExpression, sqlFunctionName: string): BasicConversionResult;
	    getConfigurationValue(_name: string): string;
	    private convertIdentifier;
	    /**
	     * Convert a list of arguments to a list of conversion results,
	     * after checking their type.
	     */
	    convertArgs(args: estree.BaseExpression[], types: ConversionResultType[], name: string): BasicConversionResult[];
	    protected convertMethodCall(expression: estree.CallExpression, result: BasicConversionResult, methodName: string, args: (estree.Expression | estree.SpreadElement)[]): BasicConversionResult;
	    private getFullMemberName;
	    protected convertRegistryFunctionCall(callExpression: estree.CallExpression, functionEntry: ConvertibleFunctionEntry, args: (estree.Expression | estree.SpreadElement)[]): BasicConversionResult;
	    protected convertMemberCallExpression(expression: estree.CallExpression, member: estree.MemberExpression): BasicConversionResult;
	    private convertCallExpression;
	    private convertTSNonNullExpression;
	    private convertTSAsExpression;
	    private convertAwaitExpression;
	    private _convertExpression;
	    convertExpression(expression: estree.BaseExpression, isMemberOf?: boolean): BasicConversionResult<FactoryT, PropertyT>;
	    convertVariableDeclaration(statement: estree.VariableDeclaration): void;
	    private convertExpressionStatement;
	    convertIfStatement(statement: estree.IfStatement): IfSqlResult;
	    convertReturnStatement(statement: estree.ReturnStatement): BasicConversionResult;
	    convertStatements(statements: estree.Statement[]): BasicConversionResult;
	    convertFunctionExpression(expression: estree.FunctionExpression | estree.ArrowFunctionExpression): BasicConversionResult;
	    convertArrowFunctionExpression(expression: estree.ArrowFunctionExpression): BasicConversionResult;
	    parseFunctionSource(str: string): estree.ArrowFunctionExpression | estree.FunctionExpression;
	    parseFunction(fn: Function): estree.ArrowFunctionExpression | estree.FunctionExpression;
	    convertFunctionBodyExpression(expression: estree.ArrowFunctionExpression | estree.FunctionExpression): BasicConversionResult;
	    convertFunctionSource(str: string): BasicConversionResult;
	    convertFunction(fn: () => AsyncResponse<AnyValue>): BasicConversionResult;
	    convertFunctionBody(result: GenericConversionResult<FactoryT, PropertyT>, body: string): BasicConversionResult;
	    private static readonly safeStringLiterals;
	    static addSafeStringLiterals(literals: string[]): void;
	    static isSafeStringLiteral(literal: string): boolean;
	}
	export {};
	//# sourceMappingURL=converter.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-ts-to-sql/build/lib/conversion-error.d.ts
declare module '@sage/xtrem-ts-to-sql/lib/conversion-error' {
	import * as estree from 'estree';
	export class ConversionError extends Error {
	    node: estree.BaseNode | undefined;
	    readonly innerError?: Error | undefined;
	    constructor(node: estree.BaseNode | undefined, message: string, innerError?: Error | undefined);
	}
	//# sourceMappingURL=conversion-error.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-ts-to-sql/build/lib/converter-lib/types-lib-converter.d.ts
declare module '@sage/xtrem-ts-to-sql/lib/converter-lib/types-lib-converter' {
	import * as estree from 'estree';
	import { Converter } from '@sage/xtrem-ts-to-sql/lib/converter';
	import { BasicConversionResult } from '@sage/xtrem-ts-to-sql/lib/types';
	/**
	 * Converts Math function calls to SQL.
	 */
	export class TypesLibConverter {
	    /**
	     * Mapping of typesLib.* functions to "classic" expressions
	     * For instance, typesLib.strictEq(a, b) will be mapped to a === b
	     */
	    static convertTypesLibExpression(converter: Converter, _expression: estree.CallExpression, op: string, args: estree.BaseExpression[]): BasicConversionResult;
	    static convertTypesLibDecimalConstructorCall(converter: Converter, expression: estree.CallExpression, args: estree.BaseExpression[]): BasicConversionResult;
	    static convertStaticMinMaxCall(converter: Converter, expression: estree.CallExpression, sqlName: string, args: estree.BaseExpression[]): BasicConversionResult;
	    static register(): void;
	}
	//# sourceMappingURL=types-lib-converter.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-ts-to-sql/build/lib/converter-lib/string-converter.d.ts
declare module '@sage/xtrem-ts-to-sql/lib/converter-lib/string-converter' {
	import * as estree from 'estree';
	import { Converter } from '@sage/xtrem-ts-to-sql/lib/converter';
	import { BasicConversionResult } from '@sage/xtrem-ts-to-sql/lib/types';
	/**
	 * Converts string properties and method calls to SQL.
	 */
	export class StringConverter {
	    readonly converter: Converter;
	    constructor(converter: Converter);
	    /**
	     * Converts a string property to SQL.
	     * @param result - The string conversion result.
	     * @param memberName - The name of the string property.
	     * @returns The converted property as a SQL result.
	     */
	    convertLengthProperty(result: BasicConversionResult): BasicConversionResult;
	    /**
	     * Converts a string method call to SQL.
	     *
	     * @param result - The string conversion result.
	     * @param methodName - The name of the method being called.
	     * @param args - The arguments passed to the method call.
	     * @returns The SQL result.
	     */
	    convertTrimCall(result: BasicConversionResult, args: estree.BaseExpression[]): BasicConversionResult;
	    static register(): void;
	}
	//# sourceMappingURL=string-converter.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-ts-to-sql/build/lib/converter-lib/regexp-converter.d.ts
declare module '@sage/xtrem-ts-to-sql/lib/converter-lib/regexp-converter' {
	import * as estree from 'estree';
	import { Converter } from '@sage/xtrem-ts-to-sql/lib/converter';
	import { BasicConversionResult } from '@sage/xtrem-ts-to-sql/lib/types';
	/**
	 * Converts regular expression method calls to SQL.
	 */
	export class RegExpConverter {
	    private readonly converter;
	    constructor(converter: Converter);
	    /**
	     * Converts a RegExp method call to SQL.
	     *
	     * @param expression - The method call expression node.
	     * @param regexp - The regular expression to be used for conversion.
	     * @param methodName - The name of the method being called.
	     * @param args - The arguments passed to the method call.
	     * @returns The result of the conversion.
	     */
	    convertMethodCall(expression: estree.Node, regexp: RegExp, methodName: string, args: estree.BaseExpression[]): BasicConversionResult;
	}
	//# sourceMappingURL=regexp-converter.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-ts-to-sql/build/lib/converter-lib/math-converter.d.ts
declare module '@sage/xtrem-ts-to-sql/lib/converter-lib/math-converter' {
	import * as estree from 'estree';
	import { Converter } from '@sage/xtrem-ts-to-sql/lib/converter';
	import { BasicConversionResult } from '@sage/xtrem-ts-to-sql/lib/types';
	/**
	 * Converts Math function calls to SQL.
	 */
	export class MathConverter {
	    private readonly converter;
	    constructor(converter: Converter);
	    convertMathStaticMethod(expression: estree.CallExpression, sqlName: string, args: estree.BaseExpression[]): BasicConversionResult;
	    static register(): void;
	}
	//# sourceMappingURL=math-converter.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-ts-to-sql/build/lib/converter-lib/decimal-converter.d.ts
declare module '@sage/xtrem-ts-to-sql/lib/converter-lib/decimal-converter' {
	import * as estree from 'estree';
	import { Converter } from '@sage/xtrem-ts-to-sql/lib/converter';
	import { BasicConversionResult } from '@sage/xtrem-ts-to-sql/lib/types';
	/**
	 * Converts date expressions to SQL.
	 */
	export class DecimalConverter {
	    private readonly converter;
	    constructor(converter: Converter);
	    /**
	     * Converts a static method call on DateValue to SQL.
	     *
	     * @param identifier - The name of the static method being called.
	     * @param args - The arguments passed to the static method.
	     * @returns The result of the conversion.
	     */
	    convertStaticRoundAtCall(expression: estree.CallExpression, args: estree.BaseExpression[]): BasicConversionResult;
	    static register(): void;
	}
	//# sourceMappingURL=decimal-converter.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-ts-to-sql/build/lib/converter-lib/context-converter.d.ts
declare module '@sage/xtrem-ts-to-sql/lib/converter-lib/context-converter' {
	/**
	 * Converts Math function calls to SQL.
	 */
	export class ContextConverter {
	    private static convertConfigurationValueCallExpression;
	    static register(): void;
	}
	//# sourceMappingURL=context-converter.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-ts-to-sql/build/lib/converter-lib/collection-converter.d.ts
declare module '@sage/xtrem-ts-to-sql/lib/converter-lib/collection-converter' {
	import { Dict } from '@sage/xtrem-shared';
	import * as estree from 'estree';
	import { Converter } from '@sage/xtrem-ts-to-sql/lib/converter';
	import { BasicConversionResult, GenericConversionResult } from '@sage/xtrem-ts-to-sql/lib/types';
	export interface CollectionWhereResult extends GenericConversionResult {
	    extraType: 'collectionWhere';
	    whereCallback: estree.ArrowFunctionExpression;
	}
	/**
	 * Converts collection properties and method calls to SQL.
	 */
	export class CollectionConverter {
	    private readonly converter;
	    constructor(converter: Converter);
	    private convertCollectionCallback;
	    private convertQuantifiedCallback;
	    private convertQuantifiedExpression;
	    convertSumCallbacks(collection: GenericConversionResult, whereCallback: estree.ArrowFunctionExpression | undefined, sumCallback: estree.ArrowFunctionExpression): BasicConversionResult;
	    private convertSumExpression;
	    convertCollectionCallbacks(collection: GenericConversionResult, callbacks: Dict<estree.ArrowFunctionExpression>): {
	        callbacksResults: Dict<BasicConversionResult>;
	        aliases: string;
	        joinCondition: string;
	    };
	    private convertTakeOneCallback;
	    private convertWhereExpression;
	    private convertWhereSumExpression;
	    private convertTakeOneExpression;
	    private convertLengthProperty;
	    static register(): void;
	}
	//# sourceMappingURL=collection-converter.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-ts-to-sql/build/lib/converter-lib/array-converter.d.ts
declare module '@sage/xtrem-ts-to-sql/lib/converter-lib/array-converter' {
	import * as estree from 'estree';
	import { Converter } from '@sage/xtrem-ts-to-sql/lib/converter';
	import { BasicConversionResult } from '@sage/xtrem-ts-to-sql/lib/types';
	/**
	 * Converts array expressions to SQL.
	 */
	export class ArrayConverter {
	    private readonly converter;
	    constructor(converter: Converter);
	    /**
	     * Converts a method call on an array literal to a SQL query.
	     * @param object - The array literal expression.
	     * @param methodName - The name of the method being called.
	     * @param args - The arguments passed to the method.
	     * @returns The result of the conversion.
	     */
	    convertLiteralMethodCall(object: estree.ArrayExpression, methodName: string, args: estree.BaseExpression[]): BasicConversionResult;
	}
	//# sourceMappingURL=array-converter.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-ts-to-sql/build/lib/converter-lib/date/sql-server-date-converter.d.ts
declare module '@sage/xtrem-ts-to-sql/lib/converter-lib/date/sql-server-date-converter' {
	import * as estree from 'estree';
	import { BasicConversionResult } from '@sage/xtrem-ts-to-sql/lib/types';
	import { DateConverter, DateFunctions, DateInterval } from '@sage/xtrem-ts-to-sql/lib/converter-lib/date/date-converter';
	/**
	 * Converts date expressions to SQL.
	 */
	export class SqlServerDateConverter extends DateConverter {
	    dateSqlFields: Record<DateFunctions, (from: string) => string>;
	    readonly currentDate = "GETDATE()";
	    convertAddIntervalCall(result: BasicConversionResult, args: estree.BaseExpression[], methodName: string, intervalName: DateInterval): BasicConversionResult;
	    convertAddDaysCall(result: BasicConversionResult, args: estree.BaseExpression[]): BasicConversionResult;
	    convertDaysDiffCall(result: BasicConversionResult, args: estree.BaseExpression[]): BasicConversionResult;
	    convertDaysInMonthCall(result: BasicConversionResult, args: estree.BaseExpression[]): BasicConversionResult;
	    convertBegOfIntervalCall(result: BasicConversionResult, args: estree.BaseExpression[], methodName: string, intervalName: DateInterval): BasicConversionResult;
	    convertEndOfIntervalCall(result: BasicConversionResult, args: estree.BaseExpression[], methodName: string, intervalName: DateInterval): BasicConversionResult;
	}
	//# sourceMappingURL=sql-server-date-converter.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-ts-to-sql/build/lib/converter-lib/date/postgres-date-converter.d.ts
declare module '@sage/xtrem-ts-to-sql/lib/converter-lib/date/postgres-date-converter' {
	import * as estree from 'estree';
	import { BasicConversionResult } from '@sage/xtrem-ts-to-sql/lib/types';
	import { DateConverter, DateFunctions, DateInterval } from '@sage/xtrem-ts-to-sql/lib/converter-lib/date/date-converter';
	/**
	 * Converts date expressions to SQL.
	 */
	export class PostgresDateConverter extends DateConverter {
	    dateSqlFields: Record<DateFunctions, (from: string) => string>;
	    readonly currentDate = "CURRENT_DATE";
	    convertAddIntervalCall(result: BasicConversionResult, args: estree.BaseExpression[], methodName: string, intervalName: DateInterval): BasicConversionResult;
	    convertAddDaysCall(result: BasicConversionResult, args: estree.BaseExpression[]): BasicConversionResult;
	    convertDaysDiffCall(result: BasicConversionResult, args: estree.BaseExpression[]): BasicConversionResult;
	    convertDaysInMonthCall(result: BasicConversionResult, args: estree.BaseExpression[]): BasicConversionResult;
	    convertBegOfIntervalCall(result: BasicConversionResult, args: estree.BaseExpression[], methodName: string, intervalName: DateInterval): BasicConversionResult;
	    convertEndOfIntervalCall(result: BasicConversionResult, args: estree.BaseExpression[], methodName: string, intervalName: DateInterval): BasicConversionResult;
	}
	//# sourceMappingURL=postgres-date-converter.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-ts-to-sql/build/lib/converter-lib/date/oracle-date-converter.d.ts
declare module '@sage/xtrem-ts-to-sql/lib/converter-lib/date/oracle-date-converter' {
	import * as estree from 'estree';
	import { BasicConversionResult } from '@sage/xtrem-ts-to-sql/lib/types';
	import { DateConverter, DateFunctions, DateInterval } from '@sage/xtrem-ts-to-sql/lib/converter-lib/date/date-converter';
	/**
	 * Converts date expressions to SQL.
	 */
	export class OracleDateConverter extends DateConverter {
	    dateSqlFields: Record<DateFunctions, (from: string) => string>;
	    readonly currentDate = "SYSDATE";
	    convertAddIntervalCall(result: BasicConversionResult, args: estree.BaseExpression[], methodName: string, intervalName: DateInterval): BasicConversionResult;
	    convertAddDaysCall(result: BasicConversionResult, args: estree.BaseExpression[]): BasicConversionResult;
	    convertDaysDiffCall(result: BasicConversionResult, args: estree.BaseExpression[]): BasicConversionResult;
	    convertDaysInMonthCall(result: BasicConversionResult, args: estree.BaseExpression[]): BasicConversionResult;
	    convertBegOfIntervalCall(result: BasicConversionResult, args: estree.BaseExpression[], methodName: string, intervalName: DateInterval): BasicConversionResult;
	    convertEndOfIntervalCall(result: BasicConversionResult, args: estree.BaseExpression[], methodName: string, intervalName: DateInterval): BasicConversionResult;
	}
	//# sourceMappingURL=oracle-date-converter.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-ts-to-sql/build/lib/converter-lib/date/index.d.ts
declare module '@sage/xtrem-ts-to-sql/lib/converter-lib/date/index' {
	export * from '@sage/xtrem-ts-to-sql/lib/converter-lib/date/date-converter';
	export * from '@sage/xtrem-ts-to-sql/lib/converter-lib/date/oracle-date-converter';
	export * from '@sage/xtrem-ts-to-sql/lib/converter-lib/date/postgres-date-converter';
	export * from '@sage/xtrem-ts-to-sql/lib/converter-lib/date/sql-server-date-converter';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-ts-to-sql/build/lib/converter-lib/date/date-converter.d.ts
declare module '@sage/xtrem-ts-to-sql/lib/converter-lib/date/date-converter' {
	import * as estree from 'estree';
	import { Converter } from '@sage/xtrem-ts-to-sql/lib/converter';
	import { BasicConversionResult } from '@sage/xtrem-ts-to-sql/lib/types';
	export type DateFunctions = 'epoch' | 'year' | 'month' | 'day' | 'week' | 'weekDay' | 'yearDay' | 'value' | 'isLeapYear';
	export type DateInterval = 'year' | 'month' | 'week' | 'quarter';
	/**
	 * Converts date expressions to SQL.
	 */
	export abstract class DateConverter {
	    protected readonly converter: Converter;
	    constructor(converter: Converter);
	    convertArgs: (args: estree.BaseExpression[], types: import("../../types").ConversionResultType[], name: string) => BasicConversionResult<import("../../types").ConverterFactory, import("../../types").ConverterProperty>[];
	    get dialect(): string;
	    abstract dateSqlFields: Record<DateFunctions, (from: string) => string>;
	    /**
	     * Retrieves the SQL expression for a date method.
	     * @param field
	     * @param from
	     * @returns
	     */
	    private datePart;
	    private convertDateProperty;
	    /**
	     * Converts a date property to SQL.
	     * @param result - The date conversion result.
	     * @param memberName - The name of the date property.
	     * @returns The converted property as a SQL result.
	     */
	    convertProperty(result: BasicConversionResult, memberName: string): BasicConversionResult;
	    /**
	     * The SQL expression to get the current date for the specific SQL dialect.
	     */
	    abstract currentDate: string;
	    /**
	     * Converts a static method call on DateValue to SQL.
	     *
	     * @param identifier - The name of the static method being called.
	     * @param args - The arguments passed to the static method.
	     * @returns The result of the conversion.
	     */
	    convertStaticDateParse(expression: estree.CallExpression, args: estree.BaseExpression[]): BasicConversionResult;
	    convertStaticDateToday(expression: estree.CallExpression, args: estree.BaseExpression[]): BasicConversionResult;
	    /**
	     * Converts a call to the compare method of Date class.
	     * @param result
	     * @param args
	     * @returns
	     */
	    protected convertCompareCall(result: BasicConversionResult, args: estree.BaseExpression[]): BasicConversionResult;
	    /**
	     * Converts the equality check of 2 dates.
	     * @param result
	     * @param args
	     * @returns
	     */
	    private convertEqualsCall;
	    /**
	     * Converts a call to the isBetween method of Date class.
	     * @param result
	     * @param args
	     * @returns
	     */
	    protected convertIsBetweenCall(result: BasicConversionResult, args: estree.BaseExpression[]): BasicConversionResult;
	    /**
	     * Converts a call to the isLeapYear method of Date class.
	     * @param result
	     * @param args
	     * @returns
	     */
	    protected convertIsLeapYearCall(result: BasicConversionResult, args: estree.BaseExpression[]): BasicConversionResult;
	    /**
	     * Converts a call to the isWorkDay method of Date class. Checking if the day of the week is Saturday or Sunday.
	     * @param result
	     * @param args
	     * @returns
	     */
	    protected convertIsWorkDayCall(result: BasicConversionResult, args: estree.BaseExpression[]): BasicConversionResult;
	    /**
	     * Convert a call to a method that adds an interval (week, month, year) to a date.
	     * @param result
	     * @param args
	     * @param methodName
	     * @param intervalName
	     * @returns
	     */
	    abstract convertAddIntervalCall(result: BasicConversionResult, args: estree.BaseExpression[], methodName: string, intervalName: DateInterval): BasicConversionResult;
	    /**
	     * Convert call to addDays method
	     * @param result
	     * @param args
	     * @returns
	     */
	    abstract convertAddDaysCall(result: BasicConversionResult, args: estree.BaseExpression[]): BasicConversionResult;
	    /**
	     * Convert call to the daysDiff method
	     * @param result
	     * @param args
	     * @returns
	     */
	    abstract convertDaysDiffCall(result: BasicConversionResult, args: estree.BaseExpression[]): BasicConversionResult;
	    /**
	     * Convert call to the daysInMonth method
	     * @param result
	     * @param args
	     */
	    abstract convertDaysInMonthCall(result: BasicConversionResult, args: estree.BaseExpression[]): BasicConversionResult;
	    /**
	     * Convert call to the begOfYear, begOfMonth, begOfQuarter and begOfWeek methods
	     * @param result
	     * @param args
	     * @param methodName
	     * @param intervalName
	     * @returns
	     */
	    abstract convertBegOfIntervalCall(result: BasicConversionResult, args: estree.BaseExpression[], methodName: string, intervalName: DateInterval): BasicConversionResult;
	    /**
	     * Convert call to the endOfYear, endOfMonth, endOfQuarter and endOfWeek methods
	     * @param result
	     * @param args
	     * @param methodName
	     * @param intervalName
	     * @returns
	     */
	    abstract convertEndOfIntervalCall(result: BasicConversionResult, args: estree.BaseExpression[], methodName: string, intervalName: DateInterval): BasicConversionResult;
	    static register(): void;
	}
	//# sourceMappingURL=date-converter.d.ts.map
}
declare module '@sage/xtrem-ts-to-sql' {
	export * from '@sage/xtrem-ts-to-sql/index';
}
