/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.TypesLibConverter=void 0;const conversion_error_1=require("../conversion-error"),registry_1=require("../registry");class TypesLibConverter{static convertTypesLibExpression(e,t,r,s){return e.convertExpression({type:"BinaryExpression",operator:r,left:s[0],right:s[1]})}static convertTypesLibDecimalConstructorCall(e,t,r){if(1!==r.length)throw new conversion_error_1.ConversionError(t,`Decimal constructor: expected 1 argument, got ${r.length}`);return e.convertExpression(r[0])}static convertStaticMinMaxCall(e,t,r,s){if(s.length<1)throw new conversion_error_1.ConversionError(t,`${r}: expected at least 1 argument, got ${s.length}`);return e.convertNaryCallExpression(t,r)}static register(){registry_1.registry.registerBuiltInFunctions({"typesLib.eq":(e,t,r)=>this.convertTypesLibExpression(e,t,"==",r),"typesLib.strictEq":(e,t,r)=>this.convertTypesLibExpression(e,t,"===",r),"typesLib.ne":(e,t,r)=>this.convertTypesLibExpression(e,t,"!=",r),"typesLib.strictNe":(e,t,r)=>this.convertTypesLibExpression(e,t,"!==",r),"typesLib.lt":(e,t,r)=>this.convertTypesLibExpression(e,t,"<",r),"typesLib.lte":(e,t,r)=>this.convertTypesLibExpression(e,t,"<=",r),"typesLib.gt":(e,t,r)=>this.convertTypesLibExpression(e,t,">",r),"typesLib.gte":(e,t,r)=>this.convertTypesLibExpression(e,t,">=",r),"typesLib.add":(e,t,r)=>this.convertTypesLibExpression(e,t,"+",r),"typesLib.sub":(e,t,r)=>this.convertTypesLibExpression(e,t,"-",r),"typesLib.mul":(e,t,r)=>this.convertTypesLibExpression(e,t,"*",r),"typesLib.div":(e,t,r)=>this.convertTypesLibExpression(e,t,"/",r),"typesLib.decimal":(e,t,r)=>this.convertTypesLibDecimalConstructorCall(e,t,r),"typesLib.min":(e,t,r)=>this.convertStaticMinMaxCall(e,t,"LEAST",r),"typesLib.max":(e,t,r)=>this.convertStaticMinMaxCall(e,t,"GREATEST",r)})}}exports.TypesLibConverter=TypesLibConverter;
//# sourceMappingURL=types-lib-converter.js.map