import * as estree from 'estree';
import { Converter } from '../converter';
import { BasicConversionResult } from '../types';
/**
 * Converts string properties and method calls to SQL.
 */
export declare class StringConverter {
    readonly converter: Converter;
    constructor(converter: Converter);
    /**
     * Converts a string property to SQL.
     * @param result - The string conversion result.
     * @param memberName - The name of the string property.
     * @returns The converted property as a SQL result.
     */
    convertLengthProperty(result: BasicConversionResult): BasicConversionResult;
    /**
     * Converts a string method call to SQL.
     *
     * @param result - The string conversion result.
     * @param methodName - The name of the method being called.
     * @param args - The arguments passed to the method call.
     * @returns The SQL result.
     */
    convertTrimCall(result: BasicConversionResult, args: estree.BaseExpression[]): BasicConversionResult;
    static register(): void;
}
//# sourceMappingURL=string-converter.d.ts.map