import * as estree from 'estree';
import { BasicConversionResult } from '../../types';
import { DateConverter, DateFunctions, DateInterval } from './date-converter';
/**
 * Converts date expressions to SQL.
 */
export declare class SqlServerDateConverter extends DateConverter {
    dateSqlFields: Record<DateFunctions, (from: string) => string>;
    readonly currentDate = "GETDATE()";
    convertAddIntervalCall(result: BasicConversionResult, args: estree.BaseExpression[], methodName: string, intervalName: DateInterval): BasicConversionResult;
    convertAddDaysCall(result: BasicConversionResult, args: estree.BaseExpression[]): BasicConversionResult;
    convertDaysDiffCall(result: BasicConversionResult, args: estree.BaseExpression[]): BasicConversionResult;
    convertDaysInMonthCall(result: BasicConversionResult, args: estree.BaseExpression[]): BasicConversionResult;
    convertBegOfIntervalCall(result: BasicConversionResult, args: estree.BaseExpression[], methodName: string, intervalName: DateInterval): BasicConversionResult;
    convertEndOfIntervalCall(result: BasicConversionResult, args: estree.BaseExpression[], methodName: string, intervalName: DateInterval): BasicConversionResult;
}
//# sourceMappingURL=sql-server-date-converter.d.ts.map