import * as estree from 'estree';
import { Converter } from '../../converter';
import { BasicConversionResult } from '../../types';
export type DateFunctions = 'epoch' | 'year' | 'month' | 'day' | 'week' | 'weekDay' | 'yearDay' | 'value' | 'isLeapYear';
export type DateInterval = 'year' | 'month' | 'week' | 'quarter';
/**
 * Converts date expressions to SQL.
 */
export declare abstract class DateConverter {
    protected readonly converter: Converter;
    constructor(converter: Converter);
    convertArgs: (args: estree.BaseExpression[], types: import("../../types").ConversionResultType[], name: string) => BasicConversionResult<import("../../types").ConverterFactory, import("../../types").ConverterProperty>[];
    get dialect(): string;
    abstract dateSqlFields: Record<DateFunctions, (from: string) => string>;
    /**
     * Retrieves the SQL expression for a date method.
     * @param field
     * @param from
     * @returns
     */
    private datePart;
    private convertDateProperty;
    /**
     * Converts a date property to SQL.
     * @param result - The date conversion result.
     * @param memberName - The name of the date property.
     * @returns The converted property as a SQL result.
     */
    convertProperty(result: BasicConversionResult, memberName: string): BasicConversionResult;
    /**
     * The SQL expression to get the current date for the specific SQL dialect.
     */
    abstract currentDate: string;
    /**
     * Converts a static method call on DateValue to SQL.
     *
     * @param identifier - The name of the static method being called.
     * @param args - The arguments passed to the static method.
     * @returns The result of the conversion.
     */
    convertStaticDateParse(expression: estree.CallExpression, args: estree.BaseExpression[]): BasicConversionResult;
    convertStaticDateToday(expression: estree.CallExpression, args: estree.BaseExpression[]): BasicConversionResult;
    /**
     * Converts a call to the compare method of Date class.
     * @param result
     * @param args
     * @returns
     */
    protected convertCompareCall(result: BasicConversionResult, args: estree.BaseExpression[]): BasicConversionResult;
    /**
     * Converts the equality check of 2 dates.
     * @param result
     * @param args
     * @returns
     */
    private convertEqualsCall;
    /**
     * Converts a call to the isBetween method of Date class.
     * @param result
     * @param args
     * @returns
     */
    protected convertIsBetweenCall(result: BasicConversionResult, args: estree.BaseExpression[]): BasicConversionResult;
    /**
     * Converts a call to the isLeapYear method of Date class.
     * @param result
     * @param args
     * @returns
     */
    protected convertIsLeapYearCall(result: BasicConversionResult, args: estree.BaseExpression[]): BasicConversionResult;
    /**
     * Converts a call to the isWorkDay method of Date class. Checking if the day of the week is Saturday or Sunday.
     * @param result
     * @param args
     * @returns
     */
    protected convertIsWorkDayCall(result: BasicConversionResult, args: estree.BaseExpression[]): BasicConversionResult;
    /**
     * Convert a call to a method that adds an interval (week, month, year) to a date.
     * @param result
     * @param args
     * @param methodName
     * @param intervalName
     * @returns
     */
    abstract convertAddIntervalCall(result: BasicConversionResult, args: estree.BaseExpression[], methodName: string, intervalName: DateInterval): BasicConversionResult;
    /**
     * Convert call to addDays method
     * @param result
     * @param args
     * @returns
     */
    abstract convertAddDaysCall(result: BasicConversionResult, args: estree.BaseExpression[]): BasicConversionResult;
    /**
     * Convert call to the daysDiff method
     * @param result
     * @param args
     * @returns
     */
    abstract convertDaysDiffCall(result: BasicConversionResult, args: estree.BaseExpression[]): BasicConversionResult;
    /**
     * Convert call to the daysInMonth method
     * @param result
     * @param args
     */
    abstract convertDaysInMonthCall(result: BasicConversionResult, args: estree.BaseExpression[]): BasicConversionResult;
    /**
     * Convert call to the begOfYear, begOfMonth, begOfQuarter and begOfWeek methods
     * @param result
     * @param args
     * @param methodName
     * @param intervalName
     * @returns
     */
    abstract convertBegOfIntervalCall(result: BasicConversionResult, args: estree.BaseExpression[], methodName: string, intervalName: DateInterval): BasicConversionResult;
    /**
     * Convert call to the endOfYear, endOfMonth, endOfQuarter and endOfWeek methods
     * @param result
     * @param args
     * @param methodName
     * @param intervalName
     * @returns
     */
    abstract convertEndOfIntervalCall(result: BasicConversionResult, args: estree.BaseExpression[], methodName: string, intervalName: DateInterval): BasicConversionResult;
    static register(): void;
}
//# sourceMappingURL=date-converter.d.ts.map