import type { Dict, RootMenuItem, StandaloneConfig, Notification } from '@sage/xtrem-shared';
import type { integration } from '@sage/xtrem-ui';
import type { UserDetails } from '../service/auth-service';
import type { TenantItem } from '../service/tenants-service';
import type { ChatbotConfiguration } from '../service/chatbot-service';
export interface ReduxResponsive {
    is: ResponsiveTypes;
    greaterThan: ResponsiveTypes;
    lessThan: ResponsiveTypes;
    mediaType: string;
    orientation: string;
}
export interface ResponsiveTypes {
    xs: boolean;
    s: boolean;
    m: boolean;
    l: boolean;
}
export interface XtremStandaloneState {
    config: StandaloneConfig | null;
    loginService: string | null;
    menuItems: integration.Menu[];
    pageTitle: string | null;
    sitemap: RootMenuItem[];
    path: string;
    tenantsList: TenantItem;
    user: UserDetails | null;
    notifications: Notification[];
    isApplicationDirty: boolean;
    preNavigationConfirmation: (() => Promise<void>) | null;
    translations: Dict<string>;
    browser: ReduxResponsive;
    isNavigationOpen: boolean;
    isNotificationCenterOpen: boolean;
    isChatbotOpen: boolean;
    chatbotConfig: ChatbotConfiguration | null;
}
//# sourceMappingURL=state.d.ts.map