import { refreshNotifications } from '../standalone-redux/actions';
import { getStore } from '../standalone-redux/store';
/**
 * websocket url always the same for all clusters, replace cluster name by websocket and keep rest of the domain
 */
export const extractWebsocketUrlFromCurrentDomain = () => {
    const hostnameComponents = document.location.hostname.split('.');
    const portNumber = document.location.port;
    return `${window.location.protocol === 'https:' ? 'wss' : 'ws'}://websocket.${hostnameComponents
        .filter((_, index) => index > 0)
        .join('.')}:${portNumber}`;
};
export const initiateSocketConnection = (protocols) => {
    let keepAliveIntervalRef;
    const webSocket = new WebSocket(extractWebsocketUrlFromCurrentDomain(), protocols);
    const sendKeepAliveMessage = () => {
        try {
            webSocket?.send(JSON.stringify({ category: 'keepAlive' }));
        }
        catch (err) {
            // eslint-disable-next-line no-console
            console.warn(err);
        }
    };
    const clearKeepAliveInterval = () => {
        if (keepAliveIntervalRef) {
            clearInterval(keepAliveIntervalRef);
            keepAliveIntervalRef = null;
        }
    };
    webSocket.onclose = () => {
        clearKeepAliveInterval();
        setTimeout(initiateSocketConnection, 30000);
    };
    webSocket.onopen = () => {
        clearKeepAliveInterval();
        keepAliveIntervalRef = setInterval(sendKeepAliveMessage, 25000);
    };
    webSocket.onmessage = async (event) => {
        let content = {};
        try {
            content = JSON.parse(event.data);
        }
        catch {
            // Intentionally left empty
        }
        if (content.category === 'userNotification') {
            const dispatch = getStore().dispatch;
            await dispatch(refreshNotifications());
        }
    };
};
//# sourceMappingURL=socket-service.js.map