import axios from 'axios';
/**
 * List of pages where the chatbot should be activated
 */
export const CHATBOT_SUPPORTED_PAGES = ['@sage/xtrem-master-data/Customer', '@sage/xtrem-show-case/ShowCaseProduct'];
export async function fetchChatbotConfiguration(loginServiceUrl) {
    try {
        const response = await axios.post(`${loginServiceUrl}/unsecure/ai`, undefined, { withCredentials: true });
        if (!response.data?.aiToken || !response.data?.graphQL) {
            // eslint-disable-next-line no-console
            console.warn('Invalid chatbot config received.');
            // eslint-disable-next-line no-console
            console.warn(response.data);
            return null;
        }
        return { aiToken: response.data.aiToken, graphQL: response.data.graphQL };
    }
    catch (err) {
        // eslint-disable-next-line no-console
        console.warn('Failed to fetch chatbot config');
        // eslint-disable-next-line no-console
        console.warn(err);
        return null;
    }
}
//# sourceMappingURL=chatbot-service.js.map