import type { Dict } from '@sage/xtrem-shared';
export declare const RENEW_LOCK_KEY = "RENEW_LOCK_KEY";
export interface DecodedToken {
    auth0?: string;
    jti?: string;
    cluster?: string;
    sub: string;
    tenantId: string;
    mfaEnforced?: boolean;
    locale: string;
    pref: number;
    supportUserEmail?: string;
    supportUserName?: string;
    aud: string;
    iss: string;
    iat: number;
    exp: number;
}
export interface UserDetails {
    id: string | null;
    userCode: string | null;
    locale: string | null;
    email: string | null;
    firstName: string | null;
    lastName: string | null;
    photo: string | null;
    tenantId: string | null;
    uniqueTenantId: string | null;
    uniqueUserId: string | null;
    clientEncryptionKey: string;
    pref: number;
    uuid: string | null;
}
/** Parses cookies to a string indexed dictionary */
export declare const getCookies: () => Dict<string>;
/** Decodes the access_token if it exists */
export declare const getDecodedToken: () => DecodedToken | null;
/** Extracts the user details from the access token */
export declare const getUserDetails: () => Partial<UserDetails>;
/**
 * Removes the renewal lock.
 */
export declare const unlockRenewal: () => void;
/**
 * Locks the renewal so the session is not renewed concurrently if many tabs are open. It sets a timestamp of 10 seconds
 * in the future so if something fails or the user closes the tab while the session is getting renewed, it will not get
 * jammed and future sessions or other tabs can renew the token.
 */
export declare const lockRenewal: () => void;
/**
 * Checks if the token should be renewed. It should only be renewed if the access token expires in the next two minutes
 * and there isn't an active lock in place already.
 */
export declare const shouldRenewToken: () => boolean;
//# sourceMappingURL=auth-service.d.ts.map