import { useCallback, useState } from 'react';
import { createPromise } from './create-promise';
import { useSkipExternalLinkConfirmation } from './use-local-storage';
export const useExternalLinkConfirmation = ({ onCancel: onControlledCancel, onConfirm: onControlledConfirm, }) => {
    const [confirmationResolver, setConfirmationResolver] = useState();
    const [isOpen, setOpen] = useState(false);
    const [isSkipExternalLinkConfirmation, setSkipExternalLinkConfirmation] = useSkipExternalLinkConfirmation();
    const storeSkipExternalLinkConfirmation = useCallback((isSkipConfirmationChecked) => {
        if (isSkipConfirmationChecked && !isSkipExternalLinkConfirmation) {
            setSkipExternalLinkConfirmation(true);
        }
    }, [isSkipExternalLinkConfirmation, setSkipExternalLinkConfirmation]);
    const getConfirmation = useCallback(async () => {
        setOpen(true);
        const [promise, resolver] = createPromise();
        setConfirmationResolver(resolver);
        return promise;
    }, [setConfirmationResolver]);
    const onCancel = useCallback(async (isSkipConfirmationChecked) => {
        storeSkipExternalLinkConfirmation(isSkipConfirmationChecked);
        setOpen(false);
        onControlledCancel(isSkipConfirmationChecked);
        confirmationResolver?.reject();
    }, [storeSkipExternalLinkConfirmation, onControlledCancel, confirmationResolver]);
    const onConfirm = useCallback(async (isSkipConfirmationChecked) => {
        storeSkipExternalLinkConfirmation(isSkipConfirmationChecked);
        setOpen(false);
        onControlledConfirm(isSkipConfirmationChecked);
        confirmationResolver?.resolve();
    }, [storeSkipExternalLinkConfirmation, onControlledConfirm, confirmationResolver]);
    return { getConfirmation, isOpen, onCancel, onConfirm };
};
//# sourceMappingURL=use-external-link-confirmation.js.map