import { getNewRelicApi, getPendoApi } from './service/telemetry-service';
import React, { Component } from 'react';
export class ErrorBoundary extends Component {
    constructor(props) {
        super(props);
        this.state = {};
    }
    static getDerivedStateFromError(error) {
        return { error };
    }
    componentDidCatch(error, errorInfo) {
        getPendoApi()?.track('unhandledEvent', {
            message: error.message,
            stack: error.stack,
        });
        getNewRelicApi()?.noticeError(error);
        getPendoApi()?.track('unhandledEvent', {
            message: error.message,
            stack: String(errorInfo.componentStack),
        });
        // eslint-disable-next-line no-console
        console.warn(errorInfo);
    }
    render() {
        if (this.state.error) {
            return (React.createElement("div", null,
                React.createElement("h4", null, "An error occurred while loading the page. Try again."),
                React.createElement("pre", null, this.state.error?.message),
                React.createElement("pre", null, this.state.error?.stack)));
        }
        return this.props.children;
    }
}
//# sourceMappingURL=error-boundary.js.map