import { localize } from '../../service/standalone-i18n-service';
export const getSupportedLocales = (user, translations) => {
    return [
        {
            key: 'en-US',
            text: localize('@sage/xtrem-standalone/language-en-us', 'English (United States)', {}, translations, user?.locale ?? undefined),
        },
        {
            key: 'en-GB',
            text: localize('@sage/xtrem-standalone/language-en-gb', 'English (United Kingdom)', {}, translations, user?.locale ?? undefined),
        },
        {
            key: 'de-DE',
            text: localize('@sage/xtrem-standalone/language-de-de', 'German (Germany)', {}, translations, user?.locale ?? undefined),
        },
        {
            key: 'fr-FR',
            text: localize('@sage/xtrem-standalone/language-fr-fr', 'French (France)', {}, translations, user?.locale ?? undefined),
        },
        {
            key: 'es-ES',
            text: localize('@sage/xtrem-standalone/language-es-es', 'Spanish (Spain)', {}, translations, user?.locale ?? undefined),
        },
    ].sort((a, b) => a.text.localeCompare(b.text));
};
//# sourceMappingURL=get-supported-locales.js.map