import Icon from 'carbon-react/esm/components/icon';
import * as React from 'react';
import { connect } from 'react-redux';
import * as actions from '../standalone-redux/actions';
import { SitemapSubMenu } from './sitemap-submenu';
import { camelCase, sortBy } from 'lodash';
import { localize } from '../service/standalone-i18n-service';
import './navigation.scss';
export class XtremNavigation extends React.Component {
    constructor(props) {
        super(props);
        this.onToggleMenu = (event) => {
            event.preventDefault();
            this.props.setNavigationOpen(!this.props.isNavigationOpen);
        };
        this.onOpenSecondaryMenu = (secondaryOpenGroup) => (event) => {
            event.preventDefault();
            if (this.state.oldSecondaryOpenGroup === secondaryOpenGroup) {
                this.setState({ oldSecondaryOpenGroup: undefined, openSitemapRootMenuItem: undefined });
                this.props.setNavigationOpen(false);
            }
            else {
                this.setState({ oldSecondaryOpenGroup: secondaryOpenGroup, openSitemapRootMenuItem: undefined });
            }
        };
        this.onOpenSitemapRootCategory = (rootItem) => (event) => {
            event.preventDefault();
            if (this.state.openSitemapRootMenuItem === rootItem) {
                this.setState({ openSitemapRootMenuItem: undefined, oldSecondaryOpenGroup: undefined });
                this.props.setNavigationOpen(false);
            }
            else {
                this.setState({ openSitemapRootMenuItem: rootItem, oldSecondaryOpenGroup: undefined });
                this.props.setNavigationOpen(true);
                setTimeout(() => {
                    if (this.firstElementRef.current) {
                        this.firstElementRef.current.focus();
                    }
                }, 10);
            }
        };
        this.onSelectLink = (path) => (event) => {
            event.preventDefault();
            this.props.setNavigationOpen(false);
            this.setState({ oldSecondaryOpenGroup: undefined, openSitemapRootMenuItem: undefined }, () => {
                this.props.onInternalNavigationChange(path);
            });
        };
        this.onSelectHomeLink = (event) => {
            event.preventDefault();
            this.props.setNavigationOpen(false);
            this.setState({ openSitemapRootMenuItem: undefined, oldSecondaryOpenGroup: undefined }, this.props.goHome);
        };
        this.state = {};
        this.firstElementRef = React.createRef();
    }
    render() {
        const navigationPrimaryClasses = ['xe-navigation'];
        if (!this.props.isNavigationOpen) {
            navigationPrimaryClasses.push('xe-navigation-primary-closed');
        }
        const backdropClasses = ['xe-navigation-backdrop'];
        if (this.state.oldSecondaryOpenGroup || this.state.openSitemapRootMenuItem) {
            navigationPrimaryClasses.push('xe-navigation-menu-open');
            backdropClasses.push('xe-navigation-backdrop-open');
        }
        const containsCurrentOpenPage = (siteMapEntry) => {
            const screenId = siteMapEntry.id;
            if (screenId && this.props.path.includes(screenId)) {
                return true;
            }
            return Boolean(siteMapEntry?.children?.find(containsCurrentOpenPage));
        };
        const homeClasses = ['xe-navigation-menu-item'];
        if (!this.props.path) {
            homeClasses.push('xe-navigation-is-active');
        }
        const homeTranslatedText = localize('@sage/xtrem-standalone/home', 'Home', {}, this.props.translations, this.props.user?.locale || 'en-US');
        return (React.createElement("nav", { className: navigationPrimaryClasses.join(' '), "aria-label": "Navigation menu", "data-testid": "xe-navigation-menu" },
            React.createElement("div", { className: "xe-navigation-primary xe-skip-link" },
                React.createElement("div", { className: "xe-navigation-menu" },
                    React.createElement("a", { className: homeClasses.join(' '), href: "#", onClick: this.onSelectHomeLink, "data-testid": "xe-navigation-home", "aria-label": homeTranslatedText },
                        React.createElement("span", { className: "xe-navigation-menu-item-icon" },
                            React.createElement(Icon, { type: "home", color: "#FFF", m: 2 })),
                        React.createElement("span", { className: "xe-navigation-menu-item-title" }, homeTranslatedText)),
                    (this.props.sitemap || []).map(rootItem => {
                        const classNames = [
                            'xe-navigation-menu-item',
                            `xe-navigation-menu-item-${camelCase(rootItem.id)}`,
                        ];
                        if (this.state.openSitemapRootMenuItem?.id === rootItem.id) {
                            classNames.push('xe-navigation-menu-item-selected');
                        }
                        if (containsCurrentOpenPage(rootItem)) {
                            classNames.push('xe-navigation-is-active');
                        }
                        return (React.createElement("a", { key: rootItem.id, href: "#", className: classNames.join(' '), onClick: this.onOpenSitemapRootCategory(rootItem), "data-menu-item": `primary-menu-item-${rootItem.id}`, "data-testid": `xe-navigation-primary-menu-item-${rootItem.id}`, "aria-label": rootItem.title },
                            React.createElement("span", { className: "xe-navigation-menu-item-icon" },
                                React.createElement(Icon, { type: rootItem.icon, color: "#FFF", m: 2 })),
                            React.createElement("span", { className: "xe-navigation-menu-item-title" }, rootItem.title)));
                    })),
                React.createElement("div", { className: "xe-navigation-toggle" },
                    React.createElement("a", { className: "xe-navigation-menu-item", href: "#", onClick: this.onToggleMenu, "data-testid": "xe-navigation-toggle" },
                        React.createElement("span", { className: "xe-navigation-menu-item-icon" }, "\uE902"),
                        React.createElement("span", { className: "xe-navigation-menu-item-title" }, this.props.isNavigationOpen
                            ? localize('@sage/xtrem-standalone/minimize', 'Minimize', {}, this.props.translations, this.props.user?.locale || 'en-US')
                            : localize('@sage/xtrem-standalone/maximize', 'Maximize', {}, this.props.translations, this.props.user?.locale || 'en-US'))))),
            this.state.openSitemapRootMenuItem && (React.createElement("div", { className: "xe-navigation-secondary" },
                !this.props.isNavigationOpen && (React.createElement("div", { className: "xe-navigation-secondary-title", "data-testid": "xe-navigation-secondary-title" },
                    React.createElement("div", { className: "xe-navigation-secondary-title-label" }, this.state.openSitemapRootMenuItem.title))),
                React.createElement("div", { className: "xe-navigation-secondary-body" },
                    React.createElement("ul", { className: "xe-navigation-secondary-body-list" }, this.state.openSitemapRootMenuItem.children &&
                        sortBy(this.state.openSitemapRootMenuItem.children, ['priority', 'title']).map((p, i) => (React.createElement(SitemapSubMenu, { key: p.id, sitemapEntry: p, level: 1, onSelectLink: this.onSelectLink, forwardRef: i === 0 ? this.firstElementRef : undefined, path: this.props.path }))))))),
            this.state.oldSecondaryOpenGroup ||
                (this.state.openSitemapRootMenuItem && (React.createElement("div", { className: backdropClasses.join(' '), onClick: this.onOpenSecondaryMenu() })))));
    }
}
const mapStateToProps = (state) => ({
    sitemap: state.sitemap,
    user: state.user,
    isNavigationOpen: state.isNavigationOpen,
    translations: state.translations,
    path: state.path,
    onInternalNavigationChange: actions.actionStub,
    setNavigationOpen: actions.actionStub,
    goHome: actions.actionStub,
});
const mapDispatchToProps = (dispatch) => ({
    onInternalNavigationChange: (path) => dispatch(actions.onInternalNavigationChange(path, true)),
    setNavigationOpen: (isOpen) => dispatch(actions.setNavigationOpen(isOpen)),
    goHome: () => dispatch(actions.goHome()),
});
// tslint:disable-next-line:variable-name
export const ConnectedXtremNavigation = connect(mapStateToProps, mapDispatchToProps)(XtremNavigation);
//# sourceMappingURL=navigation.js.map