import type { Dict, RootMenuItem, SitemapEntry } from '@sage/xtrem-shared';
import * as React from 'react';
import type { UserDetails } from '../service/auth-service';
import './navigation.scss';
export interface XtremNavigationProps {
    sitemap: RootMenuItem[];
    user: UserDetails | null;
    path: string;
    onInternalNavigationChange: (path: string) => void;
    setNavigationOpen: (isOpen: boolean) => void;
    isNavigationOpen: boolean;
    translations: Dict<string>;
    goHome: () => void;
}
export interface XtremNavigationState {
    openSitemapRootMenuItem?: SitemapEntry;
    oldSecondaryOpenGroup?: string;
}
export declare class XtremNavigation extends React.Component<XtremNavigationProps, XtremNavigationState> {
    private firstElementRef;
    constructor(props: XtremNavigationProps);
    onToggleMenu: (event: React.MouseEvent) => void;
    onOpenSecondaryMenu: (secondaryOpenGroup?: string) => (event: React.MouseEvent) => void;
    onOpenSitemapRootCategory: (rootItem: RootMenuItem) => (event: React.MouseEvent) => void;
    onSelectLink: (path: string) => (event: React.MouseEvent) => void;
    onSelectHomeLink: (event: React.MouseEvent) => void;
    render(): React.JSX.Element;
}
export declare const ConnectedXtremNavigation: import("react-redux").ConnectedComponent<typeof XtremNavigation, {
    ref?: React.LegacyRef<XtremNavigation> | undefined;
    key?: React.Key | null | undefined;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
}>;
//# sourceMappingURL=navigation.d.ts.map