import type { Dict, Notification } from '@sage/xtrem-shared';
import type { integration } from '@sage/xtrem-ui';
import * as React from 'react';
import type { UserDetails } from '../service/auth-service';
import type { TenantItem } from '../service/tenants-service';
import './header.scss';
import type { ChatbotConfiguration } from '../service/chatbot-service';
export interface XtremHeaderProps extends XtremExternalHeaderProps {
    chatbotConfig: ChatbotConfiguration | null;
    chatbotEnabled: boolean;
    goHome: () => void;
    isExtraSmall: boolean;
    isNavigationOpen: boolean;
    isNotificationCenterOpen: boolean;
    loginService: string | null;
    menuItems: integration.Menu[];
    notifications: Notification[];
    path: string;
    productName: string | null;
    setNavigationOpen: (isOpen: boolean) => void;
    setNotificationCenterOpen: (isOpen: boolean) => void;
    tenantItem: TenantItem;
    translations: Dict<string>;
    user: UserDetails | null;
}
export interface XtremExternalHeaderProps {
    onUserChangeLocale: (locale: string | null) => void;
}
export declare function XtremHeader(props: XtremHeaderProps): React.JSX.Element;
export declare namespace XtremHeader {
    var displayName: string;
}
export declare const ConnectedXtremHeader: import("react-redux").ConnectedComponent<typeof XtremHeader, {
    onUserChangeLocale: (locale: string | null) => void;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
}>;
//# sourceMappingURL=header.d.ts.map