import * as React from 'react';
import '@sage/gms-chat-ui';
export function GmsChatWindowWrapper(props) {
    return (React.createElement("gms-chat-window", { id: "gms-chat-window", "data-testid": "gms-chat-window", "backend-url": props.backendUrl, "auth-token": props.authToken, "user-id": props.userId, "gms-client": "sdmo_v1" // specifies which GMS client to communicate with: `base_v2`, `excel_v1`, `sdmo_v1`, `sip_v1`, `sna_v1`
        , "show-sidebar": "false" // ("true"|"false") specifies whether the sidebar is visible (default: "true")
        , "show-suggestions": "false" // ("true"|"false") specifies whether the suggested questions are fetched and displayed (default: "true")
        , "show-conversation-starter": "true" // ("true"|"false") specifies whether the conversation starter is fetched and displayed (default: "true")
        , "fetch-history": "true" // ("true"|"false") specifies whether the chat history is fetched (default: "true")
        , "show-heading": "true" // ("true"|"false") specifies whether the chat window heading is visible (default "true")
        , "rounded-corners": "true" // ("true"|"false") specifies whether the chat window has rounded corners (default "true")
        , "initial-display-state": "hidden" }));
}
//# sourceMappingURL=gms-chat-window-wrapper.js.map