import * as React from 'react';
import { useSelector } from 'react-redux';
import { GmsChatWindowWrapper } from './gms-chat-window-wrapper';
import './chatbot.scss';
export function Chatbot() {
    const chatbotConfig = useSelector(s => s.chatbotConfig);
    const chatbotBackendUrl = useSelector(s => s.config?.chatbotBackendUrl || null);
    const userId = useSelector(s => s.user?.uuid || null);
    const locale = useSelector(s => s.user?.locale || null);
    if (!chatbotConfig || !chatbotBackendUrl || !userId || !locale) {
        return null;
    }
    return (React.createElement(GmsChatWindowWrapper, { authToken: `${chatbotConfig.aiToken}|${chatbotConfig.graphQL}`, backendUrl: chatbotBackendUrl, userId: userId }));
}
//# sourceMappingURL=chatbot.js.map