// From file: /agent/_work/1/s/platform/shared/xtrem-shared/build/index.d.ts
declare module '@sage/xtrem-shared/index' {
	export * from '@sage/xtrem-shared/lib/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/shared/xtrem-shared/build/lib/workflow.d.ts
declare module '@sage/xtrem-shared/lib/workflow' {
	import { NodeDetails } from '@sage/xtrem-shared/lib/ui-shared-types';
	export interface WorkflowNode {
	    key: string;
	    title: string;
	    description: string;
	    color: string;
	    icon: string;
	    configurationPage: string;
	    shape: string;
	    type: string;
	}
	export type WorkflowVariableType = NodeDetails['type'];
	export interface WorkflowVariable {
	    title: string;
	    path: string;
	    type: WorkflowVariableType;
	    node?: string;
	}
	//# sourceMappingURL=workflow.d.ts.map
}
// From file: /agent/_work/1/s/platform/shared/xtrem-shared/build/lib/validator.d.ts
declare module '@sage/xtrem-shared/lib/validator' {
	export const validator: {
	    isAlphaNumericName(value: string, options?: {
	        throw: {
	            name: string;
	        };
	    }): boolean;
	    isEmail(value: string, options?: {
	        throw: {
	            name: string;
	        };
	    }): boolean;
	};
	//# sourceMappingURL=validator.d.ts.map
}
// From file: /agent/_work/1/s/platform/shared/xtrem-shared/build/lib/util.d.ts
declare module '@sage/xtrem-shared/lib/util' {
	import type { DeepPartial } from 'ts-essentials';
	import * as ts from 'typescript';
	export { DeepPartial };
	export const pascalCase: (s: string) => string;
	/**
	 * Converts an identifier to a title
	 * Lodash startCase does it but it capitalizes every word. We only want to capitalize the first one.
	 */
	export function titleCase(str: string | undefined): string;
	/**
	 * Type name for the graphql schema
	 * @param fullName fully qualified name in the form of @vendor/package/ArtifactName. Example: @sage/x3-sales/SalesOrder
	 */
	export function schemaTypeName(fullName: string, suffix?: string): string;
	export function nameToSqlName(name: string): string;
	/** Useful to make OR condition between properties in our interface. If we put the two properties Typescript returns an a type error.
	 * E.G RequireOnlyOne<interface, 'key1' | 'key2'> */
	export type RequireOnlyOne<T, Keys extends keyof T = keyof T> = Pick<T, Exclude<keyof T, Keys>> & {
	    [K in Keys]-?: Required<Pick<T, K>> & Partial<Record<Exclude<Keys, K>, undefined>>;
	}[Keys];
	/**
	 * @TJS-additionalProperties true
	 */
	export interface Dict<T> {
	    [key: string]: T;
	}
	/**
	 * A JSON value (string, boolean, number, null, array, plain object)
	 */
	export type Json = string | boolean | number | null | Json[] | Dict<Json>;
	export type MakeAllRequired<T> = {
	    [P in keyof T]-?: MakeAllRequired<NonNullable<T[P]>>;
	};
	/**
	 * Flattens an input object into a one-level deep object
	 * having as keys dot-notated strings that represent object paths.
	 * E.g.
	 *
	 * { a: 'a', b: { c: 'c', d: { e: 'e' } } } => { a: 'a', 'b.c': 'c', 'b.d.e': 'e' }
	 *
	 *
	 * @export
	 * @param {object} [obj={}] the input object
	 * @param {string} [prefix=''] an optional prefix
	 * @param {string} [suffix=''] an optional suffix
	 * @returns {Dict<string>} a dot-notated object with paths as keys
	 */
	export function flat(obj?: object, prefix?: string, suffix?: string): Dict<string>;
	export type Maybe<T> = T | undefined;
	/**
	 * Remove all the instrumentation code added by the code coverage
	 * @param str
	 */
	export function removeCodeCoverageInstrumentation(str: string): string;
	/**
	 * Access status values
	 * - authorized - user is authorized to access the property or operation
	 * - unauthorized - user is unauthorized to access the property or operation
	 * - unavailable - property or operation is disabled by a service option
	 * - readonly - property is readonly
	 * - inactive - operation is inactive
	 */
	export type AccessStatus = 'authorized' | 'unauthorized' | 'unavailable' | 'readonly' | 'inactive';
	export type PromisifyProperties<T> = {
	    [K in keyof T]: Promise<T[K] | T[K]>;
	};
	export interface ArrayMoveResult<R> {
	    success?: boolean;
	    data: R[];
	}
	export const deepMerge: <T = any>(first: T, second: T | DeepPartial<T>, useArrayAsStart?: boolean, overrideArrays?: boolean) => T;
	export function arrayMoveMutable<T>(array: T[], fromIndex: number, toIndex: number): void;
	export function arrayMoveImmutable<T>(array: T[], fromIndex: number, toIndex: number): T[];
	export function arrayMovePreservingOrder<R extends Record<string, any>, K extends keyof R>({ fromIndex, toValue, orderByKey, data, }: {
	    fromIndex: number;
	    toValue: R[K];
	    orderByKey: K;
	    data: R[];
	}): ArrayMoveResult<R>;
	export type KeysOfValue<T, Condition> = {
	    [K in keyof T]: T[K] extends Condition ? K : never;
	}[keyof T];
	export function arrayOrderContiguous<R extends {
	    _id: string;
	}, K extends KeysOfValue<R, number>>({ orderedData, key, }: {
	    orderedData: R[];
	    key: K;
	}): {
	    columnId: K;
	    rowId: string;
	    value: R[K];
	    rowData: R;
	}[];
	export function remapObjectByKey(obj: any, keyToRemap: string, remapFunction: (value: any) => any): any;
	export type MakeNodeType<T> = {
	    [Prop in Exclude<keyof T, '_id'>]: T[Prop] extends Promise<{
	        _sourceId: Promise<string>;
	        _etag: Promise<string>;
	    }> ? Promise<MakeNodeType<T[Prop]>> : T[Prop] extends Promise<any> ? T[Prop] : Promise<T[Prop]>;
	} & {
	    _id: string | number;
	};
	export function defaultStringCompare(s1: string, s2: string): number;
	export function isSubNodeDecorator(node: ts.Node): node is ts.Decorator;
	export function isNodeExtensionDecorator(node: ts.Node): node is ts.Decorator;
	export function isAbstractNodeDecorator(filename: string, node: ts.Decorator): boolean;
	export function canExportNodeDecorator(filename: string, node: ts.Decorator): boolean;
	export function getDecoratorArguments(filename: string, node: ts.Decorator): ts.NodeArray<ts.ObjectLiteralElementLike>;
	export function getNodeStorageType(filename: string, node: ts.Decorator): string | undefined;
	//# sourceMappingURL=util.d.ts.map
}
// From file: /agent/_work/1/s/platform/shared/xtrem-shared/build/lib/user.d.ts
declare module '@sage/xtrem-shared/lib/user' {
	export interface User<T> {
	    _id: string | number;
	    email: string;
	    displayName?: string;
	    photo?: T | null;
	}
	//# sourceMappingURL=user.d.ts.map
}
// From file: /agent/_work/1/s/platform/shared/xtrem-shared/build/lib/ui-shared-types.d.ts
declare module '@sage/xtrem-shared/lib/ui-shared-types' {
	/**
	 * This file contains types that are shared between the xtrem-ui, xtrem-ui-components and other front-end folder files.
	 */
	/// <reference types="lodash" />
	import type { UnionToIntersection } from 'ts-essentials';
	import { LocalizeFunction } from '@sage/xtrem-shared/lib/locale';
	export enum GraphQLTypes {
	    Boolean = "Boolean",
	    Date = "Date",
	    DateTime = "DateTime",
	    Decimal = "Decimal",
	    Enum = "Enum",
	    ExternalReference = "ExternalReference",// Non-vital references for ADC, same as IntReference
	    Float = "Float",
	    ID = "Id",// Yes, it is lowercase 'd'
	    InputStream = "_InputStream",
	    _InputTextStream = "_InputTextStream",
	    _OutputTextStream = "_OutputTextStream",
	    Int = "Int",
	    IntOrString = "IntOrString",
	    IntReference = "IntReference",// Non-vital references
	    Json = "Json",
	    String = "String"
	}
	export const textStreams: ReadonlyArray<GraphQLTypes>;
	export type NodeTypeKind = 'LIST' | 'OBJECT' | 'SCALAR' | 'INPUT_OBJECT' | 'INTERFACE' | 'ENUM';
	export interface NodeDetails {
	    canFilter: boolean;
	    canSort: boolean;
	    enumValues?: string[];
	    isCollection?: boolean;
	    kind: NodeTypeKind;
	    label: string;
	    name: string;
	    node?: string;
	    isStored: boolean;
	    isOnInputType: boolean;
	    isOnOutputType: boolean;
	    dataType: string;
	    targetNode: string;
	    enumType: string | null;
	    isCustom: boolean;
	    isMutable: boolean;
	    type: keyof typeof GraphQLTypes | (string & Record<never, never>);
	}
	export const LESS_THAN = "lessThan";
	export const LESS_THAN_EQUAL = "lessThanOrEqual";
	export const RANGE = "inRange";
	export const MULTIPLE_RANGE = "multipleRange";
	export const GREATER_THAN = "greaterThan";
	export const GREATER_THAN_EQUAL = "greaterThanOrEqual";
	export const CONTAINS = "contains";
	export const STARTS_WITH = "startsWith";
	export const ENDS_WITH = "endsWith";
	export const MATCHES = "matches";
	export const EQUALS = "equals";
	export const NOT_EQUALS = "notEqual";
	export const MULTI_NOT_EQUALS = "multiNotEqual";
	export const SET = "set";
	export type UserCustomizableWidget = 'TABLE' | 'INDICATOR_TILE' | 'BAR_CHART' | 'LINE_CHART';
	export const RANGE_DIVIDER = "~";
	export const enumFilter: readonly ["set", "multiNotEqual"];
	export const rangeFilter: readonly ["lessThan", "lessThanOrEqual", "equals", "notEqual", "greaterThan", "greaterThanOrEqual", "inRange"];
	export const stringFilter: readonly ["contains", "startsWith", "equals", "notEqual", "endsWith", "matches", "set"];
	export type StringFilter = (typeof stringFilter)[number];
	export type MultipleRangeFilter = typeof MULTIPLE_RANGE;
	export type RangeFilter = (typeof rangeFilter)[number];
	export type EnumFilter = (typeof enumFilter)[number];
	export type SetFilter = typeof SET;
	export type BooleanFilter = typeof MATCHES;
	export class EnumType {
	    value: string;
	}
	export type FiltrableType = string | number | Date | boolean | EnumType;
	export type FilterTypeValue = StringFilter | MultipleRangeFilter | BooleanFilter | SetFilter | RangeFilter | EnumFilter;
	export type FilterType<T extends FiltrableType> = T extends string ? StringFilter | MultipleRangeFilter : T extends number | Date ? RangeFilter : T extends boolean ? BooleanFilter : T extends EnumType ? EnumFilter : never;
	export interface TreeElement<T extends any = NodeDetails> {
	    key: string;
	    id: string;
	    labelKey: string;
	    labelPath: string;
	    path?: string;
	    label: string;
	    canBeSelected?: boolean;
	    canBeExpanded?: boolean;
	    data: T;
	    title?: string;
	}
	export type Property = TreeElement;
	export type FilterProperty = Property & {
	    filterType: FilterTypeValue | 'timeFrame';
	    filterValue: any;
	    parameter?: boolean;
	};
	export interface AggregationOptions {
	    group: number;
	    operation: Aggregations | 'NONE';
	}
	export type GroupProperty = Property & AggregationOptions;
	export const filterGraphqlMapping: Record<keyof typeof GraphQLTypes, Readonly<FilterTypeValue[] | undefined>>;
	export enum FieldKey {
	    Aggregate = "Aggregate",
	    Button = "Button",
	    Calendar = "Calendar",
	    Card = "Card",
	    Chart = "Chart",
	    Checkbox = "Checkbox",
	    ContentTable = "ContentTable",
	    Count = "Count",
	    Date = "Date",
	    DetailList = "DetailList",
	    DropdownList = "DropdownList",
	    DynamicPod = "DynamicPod",
	    File = "File",
	    FileDeposit = "FileDeposit",
	    FilterEditor = "FilterEditor",
	    FilterSelect = "FilterSelect",
	    FormDesigner = "FormDesigner",
	    Icon = "Icon",
	    Image = "Image",
	    Label = "Label",
	    Link = "Link",
	    Message = "Message",
	    MultiDropdown = "MultiDropdown",
	    MultiFileDeposit = "MultiFileDeposit",
	    MultiReference = "MultiReference",
	    NestedGrid = "NestedGrid",
	    NodeBrowserTree = "NodeBrowserTree",
	    Numeric = "Numeric",
	    Plugin = "Plugin",
	    Pod = "Pod",
	    PodCollection = "PodCollection",
	    Progress = "Progress",
	    Radio = "Radio",
	    Reference = "Reference",
	    RelativeDate = "RelativeDate",
	    RichText = "RichText",
	    Select = "Select",
	    SelectionCard = "SelectionCard",
	    Separator = "Separator",
	    StaticContent = "StaticContent",
	    StepSequence = "StepSequence",
	    Switch = "Switch",
	    Table = "Table",
	    TableSummary = "TableSummary",
	    Technical = "Technical",
	    Text = "Text",
	    TextArea = "TextArea",
	    Time = "Time",
	    DatetimeRange = "DatetimeRange",
	    Toggle = "ToggleButton",
	    Tree = "Tree",
	    VisualProcess = "VisualProcess",
	    VitalPod = "VitalPod",
	    Workflow = "Workflow"
	}
	export const numericFields: ("Boolean" | "Date" | "DateTime" | "Decimal" | "Enum" | "ExternalReference" | "Float" | "_InputTextStream" | "_OutputTextStream" | "Int" | "IntOrString" | "IntReference" | "Json" | "String" | "ID" | "InputStream")[];
	export const presentationGraphqlMapping: {
	    readonly Boolean: readonly [FieldKey.Checkbox];
	    readonly Date: readonly [FieldKey.Date];
	    readonly DateTime: readonly [FieldKey.Date];
	    readonly Decimal: readonly [FieldKey.Numeric, FieldKey.Label, FieldKey.Text, FieldKey.Progress];
	    readonly Enum: readonly [FieldKey.Text, FieldKey.Label];
	    readonly ExternalReference: readonly [FieldKey.Text];
	    readonly Float: readonly [FieldKey.Numeric, FieldKey.Label, FieldKey.Text, FieldKey.Progress];
	    readonly ID: readonly [FieldKey.Text];
	    readonly InputStream: readonly [FieldKey.Text];
	    readonly _InputTextStream: readonly [FieldKey.Text];
	    readonly _OutputTextStream: readonly [FieldKey.Text];
	    readonly _InputStream: readonly [FieldKey.Text];
	    readonly Int: readonly [FieldKey.Numeric, FieldKey.Label, FieldKey.Text, FieldKey.Progress];
	    readonly IntOrString: readonly [FieldKey.Text];
	    readonly Id: readonly [FieldKey.Text];
	    readonly IntReference: readonly [FieldKey.Numeric, FieldKey.Label, FieldKey.Text, FieldKey.Progress];
	    readonly Json: readonly [FieldKey.Text];
	    readonly String: readonly [FieldKey.Text];
	};
	export const presentationEditorGraphqlMapping: {
	    readonly Boolean: readonly [FieldKey.Checkbox];
	    readonly Date: readonly [FieldKey.Date];
	    readonly DateTime: readonly [FieldKey.Date];
	    readonly Decimal: readonly [FieldKey.Numeric];
	    readonly Enum: readonly [FieldKey.Text, FieldKey.Label];
	    readonly ExternalReference: readonly [FieldKey.Text];
	    readonly Float: readonly [FieldKey.Numeric];
	    readonly ID: readonly [FieldKey.Text];
	    readonly InputStream: readonly [FieldKey.Text];
	    readonly _OutputTextStream: readonly [FieldKey.Text];
	    readonly _InputTextStream: readonly [FieldKey.Text];
	    readonly Int: readonly [FieldKey.Numeric];
	    readonly IntOrString: readonly [FieldKey.Text];
	    readonly Id: readonly [FieldKey.Text];
	    readonly IntReference: readonly [FieldKey.Numeric];
	    readonly Json: readonly [FieldKey.Text];
	    readonly String: readonly [FieldKey.Text];
	};
	export type GridNestedFieldTypes = FieldKey.Aggregate | FieldKey.Checkbox | FieldKey.Count | FieldKey.Date | FieldKey.DropdownList | FieldKey.FilterSelect | FieldKey.Icon | FieldKey.Image | FieldKey.Label | FieldKey.Link | FieldKey.Numeric | FieldKey.Progress | FieldKey.Reference | FieldKey.RelativeDate | FieldKey.Select | FieldKey.Switch | FieldKey.Technical | FieldKey.Text;
	export const ATTR_CONTEXT_OBJECT_TYPE = "data-context-object-type";
	export const ATTR_CONTEXT_OBJECT_PATH = "data-context-object-path";
	export const ATTR_CONTEXT_FILTER = "data-context-filter";
	export const ATTR_CONTEXT_CONDITION = "data-context-condition";
	export const ATTR_CONTEXT_LIST_ORDER = "data-context-list-order";
	export const ATTR_PROPERTY_DISPLAY_LABEL = "data-property-display-label";
	export const ATTR_PROPERTY_NAME = "data-property-name";
	export const ATTR_PROPERTY_DATA_FORMAT = "data-property-data-format";
	export const ATTR_PROPERTY_DATA_TYPE = "data-property-data-type";
	export const ATTR_ALIAS = "data-alias";
	export const ATTR_FOOTER_GROUP = "data-footer-group";
	export const ATTR_QUERY_TABLE_HIDDEN_ROW = "data-hidden";
	/** Used for ensuring integrity of the context and their children when the properties are dragged or copied */
	export const ATTR_PROPERTY_PARENT_CONTEXT_TYPE = "data-property-parent-context";
	export const RECORD_CONTEXT_CLASS = "record-context";
	export const QUERY_TABLE_CLASS = "query-table";
	export const PROPERTY_CLASS = "property";
	export const BLOCK_AGGREGATION_PROPERTY_NAME = "_blockAggregatedData";
	export const BLOCK_AGGREGATION_ROLLING_PROPERTY_NAME = "_blockAggregatedRollingData";
	export const ATTR_BREAK_PAGE_AFTER = "data-break-page-after";
	export const ATTR_CLASS = "class";
	export enum Aggregations {
	    min = "min",
	    max = "max",
	    sum = "sum",
	    avg = "avg",
	    distinctCount = "distinctCount"
	}
	export enum Sortings {
	    ascending = "ascending",
	    descending = "descending"
	}
	export type SortingOptions = Sortings;
	export const SORTING_OPTIONS: Sortings[];
	export const STRING_AGGREGATIONS: Aggregations[];
	export const NUMBER_AGGREGATIONS: Aggregations[];
	export const DATE_AGGREGATIONS: Aggregations[];
	export const OTHER_AGGREGATIONS: Aggregations[];
	export const aggregationsGraphqlMapping: Record<keyof typeof GraphQLTypes, Aggregations[] | undefined>;
	export const sortingGraphqlMapping: Record<keyof typeof GraphQLTypes, Sortings[] | undefined>;
	export const aggregationTranslations: ((localize: LocalizeFunction) => Record<Aggregations, string>) & import("lodash").MemoizedFunction;
	export const sortingTranslations: ((localize: LocalizeFunction) => Record<Sortings, string>) & import("lodash").MemoizedFunction;
	type UnionForAny<T> = T extends never ? 'A' : 'B';
	export type IsStrictlyAny<T> = UnionToIntersection<UnionForAny<T>> extends never ? true : false;
	export {};
	//# sourceMappingURL=ui-shared-types.d.ts.map
}
// From file: /agent/_work/1/s/platform/shared/xtrem-shared/build/lib/sql-registry-hook.d.ts
declare module '@sage/xtrem-shared/lib/sql-registry-hook' {
	/**
	 * Registers a function to the TS to SQL converter.
	 *
	 * @param fullName - The full name of the SQL function.
	 * @param fn - The function to be registered.
	 * @returns The registered function.
	 */
	export function registerSqlFunction(fullName: string, fn: Function): void;
	/**
	 * Replaces the dummy implementation of registerSqlFunction with the real one.
	 * @param hook
	 */
	export function setSqlRegistryHook(hook: (fullName: string, fn: Function) => void): void;
	//# sourceMappingURL=sql-registry-hook.d.ts.map
}
// From file: /agent/_work/1/s/platform/shared/xtrem-shared/build/lib/set-sort-values.d.ts
declare module '@sage/xtrem-shared/lib/set-sort-values' {
	export type integer = number;
	export type AnyValue = boolean | string | number | object | null | undefined | AnyValue[];
	export type AsyncResponse<T extends AnyValue | void> = T | PromiseLike<T>;
	/** silly void promise to keep sonar happy */
	export const voidPromise: Promise<void>;
	/** Interface that the `list` parameter of setSortValues must implement */
	export interface SortedList {
	    /** accessor to get the length of the list */
	    readonly length: integer;
	    /** get the value of the `_sortValue` property of the item at `index` */
	    getSortValue(index: integer): Promise<integer>;
	    /** set the value of the `_sortValue` property of the item at `index` */
	    setSortValue(index: integer, value: integer): Promise<void>;
	}
	/**
	 * Set sort values in the `[start, end[` range of `list`, a sorted list.
	 *
	 * The sort values outside of the range (if any) must already be in increasing order
	 *
	 * The function will _fix the range_.
	 * It will set the sort values for all items inside the range so that the sort values are strictly
	 * increasing across the entire list.
	 * Most of the time, the function will only set values on the items inside the range.
	 * But, in the exceptional case where we get collisions on double values because of limited precision,
	 * the function will modify the sort value on one or more items after the range.
	 */
	export function setSortValues(list: SortedList, start: integer, end: integer, options?: {
	    preserveOldValues?: boolean;
	}): Promise<void>;
	//# sourceMappingURL=set-sort-values.d.ts.map
}
// From file: /agent/_work/1/s/platform/shared/xtrem-shared/build/lib/notifications.d.ts
declare module '@sage/xtrem-shared/lib/notifications' {
	import type { IconType } from 'carbon-react/esm/components/icon/icon-type';
	export type NotificationLevel = 'error' | 'warning' | 'info' | 'success' | 'approval';
	export type NotificationActionStyle = 'primary' | 'secondary' | 'tertiary' | 'link';
	export interface InitialNotificationAction {
	    icon?: string;
	    link: string;
	    style: 'primary' | 'secondary' | 'tertiary' | 'link';
	    title: string;
	}
	export interface NotificationAction extends InitialNotificationAction {
	    _id: string;
	}
	export interface InitialNotification {
	    actions: Array<InitialNotificationAction>;
	    description: string;
	    icon: IconType;
	    level: NotificationLevel;
	    shouldDisplayToast: boolean;
	    title: string;
	}
	export interface Notification extends InitialNotification {
	    _createStamp: Date;
	    _id: string;
	    actions: Array<NotificationAction>;
	    isRead: boolean;
	}
	//# sourceMappingURL=notifications.d.ts.map
}
// From file: /agent/_work/1/s/platform/shared/xtrem-shared/build/lib/menu-item.d.ts
declare module '@sage/xtrem-shared/lib/menu-item' {
	import type { IconType } from 'carbon-react/esm/components/icon/icon-type';
	/**
	 * Menu item interface that creates a group item in the navigation menu.
	 */
	export interface MenuItemDefinition {
	    /** Unique ID, it must start with the package name */
	    id: string;
	    /** The title of the menu item */
	    title: string;
	    /** Priority that determines the order of the elements in its category. */
	    priority: number;
	    /** Used internally to store the package the menu item is declared in */
	    packageName?: string;
	}
	export interface RootMenuItem extends MenuItemDefinition {
	    /** Icon that represents on the root menu item entity */
	    icon: IconType;
	}
	export interface SubMenuItem extends MenuItemDefinition {
	    /** Parent menu item that this menu is categorized under */
	    parentMenuItem: RootMenuItem | SubMenuItem;
	}
	export interface SitemapEntry extends Partial<RootMenuItem> {
	    children?: SitemapEntry[];
	    isPage: boolean;
	    packageName?: string;
	}
	//# sourceMappingURL=menu-item.d.ts.map
}
// From file: /agent/_work/1/s/platform/shared/xtrem-shared/build/lib/logger-interface.d.ts
declare module '@sage/xtrem-shared/lib/logger-interface' {
	import { LogLevel } from '@sage/xtrem-shared/lib/config';
	export interface ProfilerCallback {
	    success: (message?: string) => void;
	    fail: (message?: string) => void;
	}
	/** Error handler type for `logger.do` */
	export type LoggerErrorHandler<T> = (err: Error) => T;
	/**
	 * Callback to determine if a message should be ignored
	 */
	export type LoggerIgnoreCallback = (message: string) => boolean;
	export interface LoggingOptions {
	    lowThreshold?: number;
	    highThreshold?: number;
	    /**
	     * The callback to determine if a message should be ignored
	     */
	    ignoreCallback?: LoggerIgnoreCallback;
	}
	export interface LoggerInterface {
	    /**
	     * Logs a message with the provided log level
	     * @param logLevel
	     * @param messageProvider
	     */
	    log(logLevel: LogLevel, messageProvider: () => string, options?: LoggingOptions): ProfilerCallback;
	    /**
	     * Logs a message with the 'info' level
	     */
	    info(messageOrCallback: string | (() => string), options?: LoggingOptions): ProfilerCallback;
	    /**
	     * Logs a message with the 'warn' level
	     */
	    warn(messageOrCallback: string | (() => string), options?: LoggingOptions): ProfilerCallback;
	    /**
	     * Logs a message with the 'verbose' level
	     */
	    verbose(messageProvider: () => string, options?: LoggingOptions): ProfilerCallback;
	    /**
	     * Logs a message with the 'debug' level
	     */
	    debug(messageProvider: () => string, options?: LoggingOptions): ProfilerCallback;
	    /**
	     * Logs a message with the 'error' level
	     */
	    error(messageOrCallback: string | (() => string), options?: LoggingOptions): ProfilerCallback;
	    /**
	     * result = do(fn, onError);
	     *
	     * Executes `fn()` silently.
	     * But if `fn()` fails, logs the stacktrace and rethrows.
	     *
	     * `onError(err)` is an optional callback which will be invoked if `fn()` fails.
	     * By default, `onError` rethrows the error, but you can rethrow a different error, typically
	     * to mask low level details, or add some context to the error.
	     * You can also use `onError` to stop the error propagation and return a special value.
	     */
	    do<T>(fn: () => T, onError?: LoggerErrorHandler<T>): T;
	}
	//# sourceMappingURL=logger-interface.d.ts.map
}
// From file: /agent/_work/1/s/platform/shared/xtrem-shared/build/lib/locale.d.ts
declare module '@sage/xtrem-shared/lib/locale' {
	export const locales: readonly ["en-US", "en-GB", "fr-FR", "es-ES", "pt-PT", "pt-BR", "ar-SA", "de-DE", "it-IT", "pl-PL", "zh-CN"];
	export type Locale = (typeof locales)[number];
	export type LocalizeLocale = Locale | 'base';
	export const supportedLocales: LocalizeLocale[];
	export type LocaleFallbacks = {
	    [key in LocalizeLocale]: LocalizeLocale[];
	};
	export const localeFallbacks: LocaleFallbacks;
	export interface LocalizeFunction {
	    (key: string, _template: string, data?: object | any[], locale?: LocalizeLocale): string;
	}
	export interface LocalizeEnumFunction {
	    (enumFullPathName: string, memberName: string): string;
	}
	//# sourceMappingURL=locale.d.ts.map
}
// From file: /agent/_work/1/s/platform/shared/xtrem-shared/build/lib/index.d.ts
declare module '@sage/xtrem-shared/lib/index' {
	/// <reference types="@sage/xtrem-decimal" />
	export { toDecimal, toInteger, toNumber } from '@sage/xtrem-decimal';
	export { attachmentsMimeTypes, attachmentsMimeTypesByExtention } from '@sage/xtrem-shared/lib/attachments-mime-types';
	export * from '@sage/xtrem-shared/lib/communication';
	export * from '@sage/xtrem-shared/lib/config';
	export * from '@sage/xtrem-shared/lib/constants';
	export * from '@sage/xtrem-shared/lib/customization';
	export * from '@sage/xtrem-shared/lib/dashboard';
	export * from '@sage/xtrem-shared/lib/data-types/index';
	export * from '@sage/xtrem-shared/lib/errors';
	export * from '@sage/xtrem-shared/lib/file-management';
	export * from '@sage/xtrem-shared/lib/format-string';
	export * from '@sage/xtrem-shared/lib/locale';
	export * from '@sage/xtrem-shared/lib/logger-interface';
	export * from '@sage/xtrem-shared/lib/menu-item';
	export * from '@sage/xtrem-shared/lib/notifications';
	export * from '@sage/xtrem-shared/lib/security/index';
	export * from '@sage/xtrem-shared/lib/set-sort-values';
	export * from '@sage/xtrem-shared/lib/sql-registry-hook';
	export * from '@sage/xtrem-shared/lib/ui-shared-types';
	export * from '@sage/xtrem-shared/lib/user';
	export * from '@sage/xtrem-shared/lib/util';
	export { validator } from '@sage/xtrem-shared/lib/validator';
	export * from '@sage/xtrem-shared/lib/workflow';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/shared/xtrem-shared/build/lib/format-string.d.ts
declare module '@sage/xtrem-shared/lib/format-string' {
	export const handleBars: (template: string, data?: any) => {
	    result: string;
	    variables: string[];
	};
	export const format: (literal: string, locale: string, data?: object | any[], noEscape?: boolean) => string;
	export const dotNotate: (input: any, prefix?: string, target?: any) => any;
	export const safeJsonParse: (input: any) => any;
	//# sourceMappingURL=format-string.d.ts.map
}
// From file: /agent/_work/1/s/platform/shared/xtrem-shared/build/lib/file-management.d.ts
declare module '@sage/xtrem-shared/lib/file-management' {
	import { MakeNodeType } from '@sage/xtrem-shared/lib/util';
	export interface UploadedFile {
	    _id: string | number;
	    mimeType: string;
	    filename: string;
	    contentLength: number;
	    status: string;
	    uploadUrl: string;
	    downloadUrl: string;
	}
	export interface UploadedFileNode extends MakeNodeType<UploadedFile> {
	}
	export interface AttachmentAssociation {
	    _id: string | number;
	    isProtected: boolean;
	    description: string;
	    title: string;
	    attachment: UploadedFileNode;
	}
	export interface AttachmentAssociationNode extends MakeNodeType<AttachmentAssociation> {
	}
	//# sourceMappingURL=file-management.d.ts.map
}
// From file: /agent/_work/1/s/platform/shared/xtrem-shared/build/lib/errors.d.ts
declare module '@sage/xtrem-shared/lib/errors' {
	export enum ValidationSeverity {
	    test = 0,
	    info = 1,
	    warn = 2,
	    error = 3,
	    exception = 4
	}
	export class ApiError extends Error {
	    readonly diagnoses: any[];
	    constructor(message: string, diagnoses: any[]);
	}
	export interface Diagnosis {
	    severity?: ValidationSeverity;
	    message?: string;
	    path?: string[];
	}
	export interface HttpError {
	    status: number;
	    statusText?: string;
	}
	interface Extensions {
	    code: string;
	    diagnoses: any[];
	    http?: HttpError;
	    rawError?: any;
	}
	export abstract class BaseError extends Error {
	    readonly innerError?: Error | undefined;
	    /** This attribute will be used to propagate this diagnoses to the GraphQL response */
	    extensions: Extensions;
	    constructor(message: string, innerError?: Error | undefined);
	}
	export abstract class ApplicationError extends BaseError {
	    constructor(message: string, innerError?: Error);
	}
	/**
	 * Thrown when a business rule is broken.
	 * The message is localized, and reaches the end user.
	 */
	export class BusinessRuleError extends ApplicationError {
	    constructor(message: string, innerError?: Error, diagnoses?: Diagnosis[]);
	}
	/**
	 * Thrown when the data provided by the user is faulty.
	 * The message is localized, and reaches the end user.
	 */
	export class DataInputError extends ApplicationError {
	    constructor(message: string, innerError?: Error);
	}
	/**
	 * Thrown if the query tries to reach unauthorized data.
	 * The message is localized, and reaches the end user.
	 */
	export class AuthorizationError extends ApplicationError {
	    constructor(message: string, innerError?: Error);
	}
	/**
	 * Not a logical error nor an application error.
	 * For instance: file not found or failed connection, or unknown.
	 * Message not localized, not returned to user.
	 */
	export class SystemError extends BaseError {
	    constructor(message: string, innerError?: Error);
	}
	/**
	 * Security errors are reserved for errors that are related to security threats.
	 * Message not localized, not returned to user.
	 */
	export class SecurityError extends BaseError {
	    constructor(message: string, innerError?: Error);
	    securityMessage(context: any): string;
	}
	/**
	 * Logical error, independent from external environment and data.
	 * For instance: failed assertion.
	 * Message not localized, not returned to user.
	 */
	export class LogicError extends BaseError {
	    constructor(message: string, innerError?: Error);
	}
	/**
	 * Timeout error, thrown if the time limit for an operation has been exceeded
	 * For instance: GraphQl time limit.
	 * The message is localized, and reaches the end user.
	 */
	export class TimeoutError extends ApplicationError {
	    constructor(message: string, innerError?: Error);
	}
	export class InteropError extends BaseError {
	    constructor(message: string, innerError?: Error);
	}
	export function unwrapError(err: Error): Error & {
	    code?: string;
	};
	export {};
	//# sourceMappingURL=errors.d.ts.map
}
// From file: /agent/_work/1/s/platform/shared/xtrem-shared/build/lib/dashboard.d.ts
declare module '@sage/xtrem-shared/lib/dashboard' {
	import { integer } from '@sage/xtrem-shared/lib/set-sort-values';
	export interface DashboardItemPosition {
	    _id: string;
	    x: integer;
	    y: integer;
	    w: integer;
	    h: integer;
	}
	export interface DashboardItem extends DashboardItemPosition {
	    _id: string;
	    type: string;
	    settings: any | null;
	}
	export interface Dashboard {
	    _id: string;
	    title: string;
	    description?: string;
	    icon?: string;
	    children: DashboardItem[];
	    isTemplate?: boolean;
	}
	//# sourceMappingURL=dashboard.d.ts.map
}
// From file: /agent/_work/1/s/platform/shared/xtrem-shared/build/lib/customization.d.ts
declare module '@sage/xtrem-shared/lib/customization' {
	import { Dict } from '@sage/xtrem-shared/lib/util';
	export interface MetaCustomizableNode {
	    node: string;
	    fullName: string;
	}
	export type MetaCustomizableNodesArray = Array<MetaCustomizableNode>;
	export interface MetaCustomField {
	    name: string;
	    title: string;
	    dataType: string;
	    targetNodeName?: string;
	    enumValues?: {
	        name: string;
	        title: string;
	    }[];
	    componentType: string;
	    anchorPropertyName?: string;
	    anchorPosition: string;
	    componentAttributes?: any;
	    destinationTypes?: string[];
	}
	export type MetaCustomFields = Dict<MetaCustomField[]>;
	export type MetaCustomFieldsArray = Array<{
	    name: string;
	    properties: MetaCustomField[];
	}>;
	//# sourceMappingURL=customization.d.ts.map
}
// From file: /agent/_work/1/s/platform/shared/xtrem-shared/build/lib/constants.d.ts
declare module '@sage/xtrem-shared/lib/constants' {
	export const CUSTOM_DATA_PROPERTY = "_customData";
	//# sourceMappingURL=constants.d.ts.map
}
// From file: /agent/_work/1/s/platform/shared/xtrem-shared/build/lib/config.d.ts
declare module '@sage/xtrem-shared/lib/config' {
	/// <reference types="node" />
	import { CommonConnectionOptions, SecureContextOptions, TlsOptions } from 'tls';
	import { Dict } from '@sage/xtrem-shared/lib/util';
	export type TlsConnectionOptions = SecureContextOptions & CommonConnectionOptions;
	export interface AddOnConfig {
	    folder: string;
	}
	export interface SqlConfig {
	    hostname: string;
	    /** Read-Only db replica hostname */
	    readonlyHostname?: string;
	    port?: number;
	    database: string;
	    user: string;
	    password: string;
	    sysDatabase?: string;
	    sysUser?: string;
	    sysPassword?: string;
	    poolMaxIdleSeconds?: number;
	    /** Number of times to retry SQL connection - default 3 */
	    connectionMaxRetries?: number;
	    /** Milliseconds to wait before retrying connection - default 2000 */
	    connectionRetryMillis?: number;
	    /** Number of transactions per connection before closing to cycle connections - default 7500 */
	    maxUses?: number;
	    /** Pool size - default 20 */
	    max?: number;
	    /** Should all the $xx parameters be replaced by their value ? */
	    mapArgsInLogs?: boolean;
	    /** Max number of retries on conflicts between transactions */
	    maxRetriesOnTransactionConflicts?: number;
	    /** Subscriber config */
	    subscriber?: SubscriberConfig;
	    /** SSL config */
	    ssl?: boolean | TlsConnectionOptions;
	    /** Size of cache of SQL statements - default 1000 */
	    sqlStatementCacheSize?: number;
	    /** Number of milliseconds before a client is terminated if it is idle - default 10000 */
	    idleTimeoutMillis?: number;
	    /** Number of milliseconds to wait before timing out when connecting a new client - default 5000 */
	    connectionTimeoutMillis?: number;
	    /** Number of milliseconds before a statement in query will time out, default is no timeout.
	     * https://node-postgres.com/apis/client
	     * https://stackoverflow.com/questions/59155572/how-to-set-query-timeout-in-relation-to-statement-timeout
	     */
	    statementTimeoutMillis?: number;
	    /** Max number of attempts to execute a SQL statement error */
	    maxTries?: number;
	    /** Delay before retrying SQL statement on error */
	    delayBeforeRetry?: number;
	    /** Maximum subquery depth that the ts-to-sql converter accepts */
	    maxSubQueryDepth?: number;
	}
	export interface SubscriberConfig {
	    /**
	     * Interval in ms to run a trivial query on the DB to see if
	     * the database connection still works.
	     * Defaults to 30s.
	     */
	    paranoidChecking?: number | false;
	    /**
	     * How much time to wait between reconnection attempts (if failed).
	     * Can also be a callback returning a delay in milliseconds.
	     * Defaults to 500 ms.
	     */
	    retryInterval?: number | ((attempt: number) => number);
	    /**
	     * How many attempts to reconnect after connection loss.
	     * Defaults to no limit, but a default retryTimeout is set.
	     */
	    retryLimit?: number;
	    /**
	     * Timeout in ms after which to stop retrying and just fail. Defaults to 3000 ms.
	     */
	    retryTimeout?: number;
	}
	export interface StorageConfig {
	    /** Is storage managed by an external storage engine (not PostgreSQL) */
	    managedExternal?: boolean;
	    /** pool size, for external storage engines (postgres uses storage.sql.max) */
	    maxConnections?: number;
	    /** Postgres configuration */
	    sql?: SqlConfig;
	}
	export interface SystemConfig {
	    /** a comma separated list of nat IP addresses */
	    natIpAdresses?: string;
	}
	/**
	 * Configuration of debug metrics
	 */
	type DebugMetricsOptions = Dict<boolean>;
	export type LogLevel = 'off' | 'error' | 'warn' | 'info' | 'verbose' | 'debug';
	export interface LogDomain {
	    level: LogLevel;
	}
	export interface LogOptions {
	    noColor?: boolean;
	    json?: boolean;
	}
	export interface LogsConfig {
	    filenamePrefix?: string;
	    outputFolder?: string;
	    domains?: Dict<LogDomain>;
	    /** Are all logs disabled? */
	    disabled?: boolean;
	    /** Are all logs disabled when running tests? */
	    disabledForTests?: boolean;
	    options?: LogOptions;
	}
	export type DeploymentMode = 'development' | 'production';
	export interface SizeLimits {
	    maxStreamSize?: string;
	    maxRequestSize?: string;
	    maxUploadSize?: string;
	}
	export interface SecurityConfig {
	    loginUrl?: string;
	    redirectUrl?: string;
	    jwksUrl?: string;
	    issuer?: string;
	    audience?: string;
	    renewalUrl?: string;
	    renewalThreshold?: number;
	    enableAutoRefresh?: boolean;
	    services?: SecurityServicesConfig;
	    tls?: {
	        extraCaFiles?: string | string[];
	    };
	    sizeLimits?: SizeLimits;
	    jsEval?: {
	        timeoutInMillis?: number;
	    };
	}
	export type AppsConfig = Dict<AppConfig>;
	export interface AppConfig {
	    appUrl: string;
	    interopUrl: string;
	    metricsUrl?: string;
	    version?: string;
	}
	export interface UiConfig {
	    include?: string[];
	    exclude?: string[];
	}
	interface StrictTransportSecurityOptions {
	    maxAge: number;
	    includeSubDomains: boolean;
	    preload: boolean;
	}
	export interface SecurityServicesConfig {
	    tokenInvalidation?: {
	        active?: boolean;
	    };
	    helmet?: {
	        disabledOptions?: {
	            csp: boolean;
	            hsts: boolean;
	        };
	        csp?: {
	            directives?: Dict<null | Iterable<string>>;
	        };
	        hsts?: boolean | StrictTransportSecurityOptions;
	    };
	    tooBusy?: {
	        disabled?: boolean;
	        maxLagInMillis?: number;
	        intervalInMillis?: number;
	        smoothingFactor?: number;
	        retryAfterInSeconds?: number;
	    };
	}
	export interface GraphQlConfig {
	    isReadonly?: boolean;
	    maxNodesPerPage?: number;
	    keepLocalConfig?: boolean;
	    timeLimitInSeconds?: number;
	}
	export interface ClusterConfig {
	    numberOfForkedProcesses: number;
	}
	export interface S3Config {
	    accessKey: string;
	    secret: string;
	    region?: string;
	}
	export interface InteropConfig {
	    /** handlebars template for queue URL (cluster V2) */
	    queueUrlTemplate?: string;
	    /** handlebars template for dead letter queue URL (cluster V2) */
	    queueUrlDeadLetterTemplate?: string;
	    queues: Dict<QueueConfig>;
	    /** size of the receiving notification funnel */
	    concurrentNotificationsLimit?: number;
	    /** size of the receiving message funnel */
	    concurrentMessagesLimit?: number;
	    /** interval of monitoring the listening queues in seconds (default to 1) */
	    listenerMonitoringSeconds?: number;
	    /** interval of notifications pooling in seconds (default to 1) */
	    routingPollingSeconds?: number;
	    /** maximum number of notifications pooling (default to 3)*/
	    routingReadCount?: number;
	    /** maximum number of retries trying to receive messages from SQS queue before error (default to 3) */
	    receiveRetryCount?: number;
	    /** interval of retries in seconds (default to 1) */
	    receiveRetrySeconds?: number;
	    /** interval to wait when polling receive queue(default to 1) */
	    receivePollingSeconds?: number;
	    /** time in seconds received message is made invisible on SQS (default 30 seconds) */
	    messageVisibilitySeconds?: number;
	    /** lower bound list size for the messages that are in progress (default to 6) */
	    receiveLowerBound?: number;
	    /** upper bound list size for the messages that are in progress (default to 11) */
	    receiveUpperBound?: number;
	    /** maximum number of retries trying to receive messages from SQS queue before error (default to 3) */
	    sendRetryCount?: number;
	    /** interval of retries in seconds (default to 90) */
	    sendRetrySeconds?: number;
	    /** Number of SQS groups per tenant user (default to 5).
	     * A given tenant user cannot have more than this number of SQS messages being processed simultaneously*/
	    sqsGroupsPerTenantUser?: number;
	    /** heartbeat rate to refresh list of live containers */
	    heartbeatSeconds?: number;
	    /** interval of apps health check in seconds (default to 60) */
	    appsHealthCheckSeconds?: number;
	    /** timeout in seconds for the interop graqhql request to be completed (default to 120) */
	    graphqlTimeLimitInSeconds?: number;
	}
	/**
	 * The interfaces for WebSockets will be refactored at a later time.
	 */
	export interface WebSocketResponseConfig {
	    restResponseEndpoint: string;
	    wsEndPoint: string;
	    authToken: string;
	}
	export interface WebSocketRequestConfig {
	    source: string;
	    websocketQueueUrl: string;
	}
	export interface WebSocketConfig {
	    dynamoDbTableName?: string;
	    request?: WebSocketRequestConfig;
	    response?: WebSocketResponseConfig;
	}
	export interface NewRelicConfig {
	    trustKey?: string;
	    accountId?: string;
	    licenceKey?: string;
	    applicationId?: string;
	}
	export interface QueueConfig {
	    url: string;
	    region?: string;
	    /** size of the queue funnel */
	    concurrentLimit?: number;
	    /** time in seconds received message is made invisible on SQS (default 30 seconds) */
	    messageVisibilitySeconds?: number;
	    /** interval to wait when polling receive queue(default to 1) */
	    receivePollingSeconds?: number;
	    /** lower bound list size for the messages that are in progress (default to 6) */
	    receiveLowerBound?: number;
	    /** upper bound list size for the messages that are in progress (default to 11) */
	    receiveUpperBound?: number;
	}
	export interface AwsConfig {
	    region: string;
	}
	export type ServiceOptionStatus = 'workInProgress' | 'experimental' | 'released';
	export interface ServiceOptions {
	    level: ServiceOptionStatus;
	}
	export interface UpgradeOptions {
	    activateNewPackages?: boolean;
	    /** associated with the CLI upgrade option --prod this option makes it possible to skip
	     * the playing of recorded SQL files.*/
	    upgradeOnly?: boolean;
	    /**
	     * Temp hack for upgrade on showcase (https://jira.sage.com/browse/XT-23045)
	     * Should all the CSV files from the SETUP layer be reloaded at the end of the upgrade ?
	     * This will bypass the lookup from the git repo and reload all the **setup** CSV files
	     */
	    fullReloadOfSetupLayer?: boolean;
	}
	export interface WorkerConfig {
	    workersPerRequestSource?: number;
	}
	export interface ServerConfig {
	    port?: number;
	    ssl?: TlsOptions;
	    metricsPort?: number;
	    interopPort?: number;
	    /** the factor to apply to the max value of the sql config in order to compute the final request funnel size */
	    requestFunnelSizeFactor?: number;
	    worker?: WorkerConfig;
	}
	export interface S3StorageConfig {
	    /**
	     * For presigned URLs, we need this when adding an exception to CSP for uploading of files by the client
	     * Example: https://xtrem-dev-eu-showcase.s3.eu-west-1.amazonaws.com
	     */
	    s3BucketUrlPrefix?: string;
	    /** Cluster's S3 bucket name used to pass to file storage instance, to upload/download tenant specific files */
	    s3ClusterBucket?: string;
	    /** The (optional) folder (s3ClusterBucket) from where the upgrade metrics should be uploaded */
	    s3UpgradeMetricsFolder?: string;
	    localBasePath?: string;
	}
	export interface PendoOptions {
	    /** pendo subscription id */
	    subscriptionId?: string;
	    /** pendo tag to identify cluster type */
	    clusterTag?: string;
	    /** The API key */
	    apiKey?: string;
	}
	export interface ImportCsvOptions {
	    chunkSize?: number;
	}
	export interface ExportCsvOptions {
	    maxRetryUploadedFileCreation?: number;
	    chunkSize?: number;
	}
	export interface ReportOptions {
	    maxTotalPages?: number;
	    browserTimeout?: number;
	    pageOpeningTimeout?: number;
	    pdfTransformationTimeout?: number;
	}
	export interface Config {
	    /** Visible product name, used in application header and metadata fields. */
	    productName?: string;
	    /** Path of config file name that we are extending */
	    extends?: string;
	    /** App name for this container in a multi-app infrastructure */
	    app?: string;
	    endpoint?: string;
	    server?: ServerConfig;
	    storage?: StorageConfig;
	    system?: SystemConfig;
	    logs?: LogsConfig;
	    settings?: Dict<any>;
	    packages?: Dict<any>;
	    tenantId?: string;
	    email?: string;
	    user?: string;
	    /** Login is the EM login */
	    login?: string;
	    /** scope of api call */
	    scope?: string;
	    /** application id registered in api gateway */
	    applicationId?: string;
	    /** application name registered in api gateway */
	    applicationName?: string;
	    deploymentMode?: DeploymentMode;
	    security?: SecurityConfig;
	    /** apps, from apps.yml (next to xtrem-config.yml or under /infra) */
	    apps?: AppsConfig;
	    uiConfigPath?: string;
	    ui?: UiConfig;
	    textServerUrl?: string;
	    graphql?: GraphQlConfig;
	    noUi?: boolean;
	    /** Disables caching the index.html template, it is practical when working on changes for xtrem-standalone in watch mode */
	    disableUiTemplateCache?: boolean;
	    /** Deploy the production UI application instead of the developer consumer mock */
	    prodUi?: boolean;
	    /** The folder where the config was loaded from */
	    originFolder?: string;
	    baseUrl?: string;
	    /** interval of error monitoring in seconds (default to 3600) */
	    errorMonitoringInterval?: number;
	    /** number of errors during the monitoring interval that will cause a process exit (default to 10) */
	    errorMonitoringThreshold?: number;
	    /** Licence key for ag-grid */
	    agGridLicenceKey?: string;
	    cluster?: ClusterConfig;
	    interop?: InteropConfig;
	    webSocket?: Dict<WebSocketConfig>;
	    s3?: Dict<S3Config>;
	    aws?: AwsConfig;
	    clusterId?: string;
	    asyncContextTableName?: string;
	    xtremDeploymentCoreTableName?: string;
	    s3Storage?: S3StorageConfig;
	    /** Salt that is used to create anonym unique user and tenant IDs */
	    telemetrySalt?: string;
	    /** URL of the documentation service where user help pages are located */
	    documentationServiceUrl?: string;
	    /** Configuration properties used for client error reporting and benchmarking */
	    newRelic?: NewRelicConfig;
	    /** Content types allowed for text streams (regex list) */
	    textStreamContentTypes?: string[];
	    /** Content types allowed for binary streams (regex list) */
	    binaryStreamContentTypes?: string[];
	    /** The level at which we will be validating the package version differences */
	    semVerCompatibilityLevel?: 'major' | 'minor' | 'patch';
	    /** Ignore vendor protection rule on data update */
	    ignoreVendorProtection?: boolean;
	    /** The level at which service options are displayed and enabled in the product
	     If this attribute is not present it is set to workInProgress in dev mode,
	     and to released in production mode.
	     */
	    serviceOptions?: ServiceOptions;
	    pendo?: PendoOptions;
	    importCsv?: ImportCsvOptions;
	    exportCsv?: ExportCsvOptions;
	    reportOptions?: ReportOptions;
	    /**
	     * Options for upgrade.
	     */
	    upgrade?: UpgradeOptions;
	    /** CLI plugins */
	    cli?: {
	        plugins?: string[];
	    };
	    /**
	     * Configuration of debug metrics
	     */
	    debugMetrics?: DebugMetricsOptions;
	    env?: {
	        isCI?: boolean;
	    };
	    extensionPath?: string;
	    addOns?: AddOnConfig;
	    /** URL to Sage Copilot chatbot backend, if not defined the chatbot is hidden. */
	    chatbotBackendUrl?: string;
	}
	export interface AuthConfig {
	    login?: string;
	    auth0?: string;
	    persona?: string;
	    tenantId?: string;
	}
	export interface DevelopmentConfig extends Config {
	    auth: AuthConfig;
	}
	export function isDevelopmentConfig(config: Config): config is DevelopmentConfig;
	export function isDevelopmentProdUiConfig(config: Config): config is DevelopmentConfig;
	export interface StandaloneConfig {
	    agGridLicenceKey: string | null;
	    productName?: string;
	    chatbotBackendUrl?: string;
	    app?: string;
	    pendoClusterTag?: string;
	}
	export function isEnvVarTrue(v: string | undefined): boolean;
	export {};
	//# sourceMappingURL=config.d.ts.map
}
// From file: /agent/_work/1/s/platform/shared/xtrem-shared/build/lib/communication.d.ts
declare module '@sage/xtrem-shared/lib/communication' {
	export interface NotificationProgress {
	    totalCount: number;
	    successCount: number;
	    errorCount: number;
	    phase: string;
	    detail: string;
	}
	//# sourceMappingURL=communication.d.ts.map
}
// From file: /agent/_work/1/s/platform/shared/xtrem-shared/build/lib/attachments-mime-types.d.ts
declare module '@sage/xtrem-shared/lib/attachments-mime-types' {
	import { Dict } from '@sage/xtrem-shared/lib/util';
	export const attachmentsMimeTypesByExtention: Dict<string[]>;
	/**
	 * Allowed mime types for attachments
	 * @see https://www.iana.org/assignments/media-types/media-types.xhtml
	 * @see https://www.npmjs.com/package/mime-db
	 * @see https://mimetype.io/
	 */
	export const attachmentsMimeTypes: string[];
	//# sourceMappingURL=attachments-mime-types.d.ts.map
}
// From file: /agent/_work/1/s/platform/shared/xtrem-shared/build/lib/security/util.d.ts
declare module '@sage/xtrem-shared/lib/security/util' {
	export function getRequestContextDetailsMessage(req: any): string;
	//# sourceMappingURL=util.d.ts.map
}
// From file: /agent/_work/1/s/platform/shared/xtrem-shared/build/lib/security/secure-coding.d.ts
declare module '@sage/xtrem-shared/lib/security/secure-coding' {
	/**
	 * Creates an empty with a null prototype to prevent from prototype pollutions
	 * @returns an empty object
	 */
	export const createPlainObject: <T>(source?: object) => T;
	/**
	 * Creates a dictionary object safe to prototype pollutions
	 * @returns an empty dictionary object
	 */
	export const createDictionary: <T>() => Record<string, T>;
	//# sourceMappingURL=secure-coding.d.ts.map
}
// From file: /agent/_work/1/s/platform/shared/xtrem-shared/build/lib/security/index.d.ts
declare module '@sage/xtrem-shared/lib/security/index' {
	export * from '@sage/xtrem-shared/lib/security/secure-coding';
	export * from '@sage/xtrem-shared/lib/security/util';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/shared/xtrem-shared/build/lib/data-types/index.d.ts
declare module '@sage/xtrem-shared/lib/data-types/index' {
	/// <reference types="@sage/xtrem-decimal" />
	export type { decimal } from '@sage/xtrem-decimal';
	const columnTypeNames: readonly ["boolean", "enum", "short", "integer", "reference", "integerRange", "decimalRange", "date", "dateRange", "datetimeRange", "time", "datetime", "float", "decimal", "double", "binaryStream", "textStream", "string", "uuid", "byte", "binary", "json", "integerArray", "enumArray", "referenceArray", "stringArray"];
	export type ColumnTypeName = (typeof columnTypeNames)[number];
	export function isColumnTypeName(name: string | undefined): boolean;
	export const MAX_INT_32: number;
	export const MIN_INT_32: number;
	//# sourceMappingURL=index.d.ts.map
}
declare module '@sage/xtrem-shared' {
	export * from '@sage/xtrem-shared/index';
}
