export type integer = number;
export type AnyValue = boolean | string | number | object | null | undefined | AnyValue[];
export type AsyncResponse<T extends AnyValue | void> = T | PromiseLike<T>;
/** silly void promise to keep sonar happy */
export declare const voidPromise: Promise<void>;
/** Interface that the `list` parameter of setSortValues must implement */
export interface SortedList {
    /** accessor to get the length of the list */
    readonly length: integer;
    /** get the value of the `_sortValue` property of the item at `index` */
    getSortValue(index: integer): Promise<integer>;
    /** set the value of the `_sortValue` property of the item at `index` */
    setSortValue(index: integer, value: integer): Promise<void>;
}
/**
 * Set sort values in the `[start, end[` range of `list`, a sorted list.
 *
 * The sort values outside of the range (if any) must already be in increasing order
 *
 * The function will _fix the range_.
 * It will set the sort values for all items inside the range so that the sort values are strictly
 * increasing across the entire list.
 * Most of the time, the function will only set values on the items inside the range.
 * But, in the exceptional case where we get collisions on double values because of limited precision,
 * the function will modify the sort value on one or more items after the range.
 */
export declare function setSortValues(list: SortedList, start: integer, end: integer, options?: {
    preserveOldValues?: boolean;
}): Promise<void>;
//# sourceMappingURL=set-sort-values.d.ts.map