"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MIN_INT_32 = exports.MAX_INT_32 = exports.isColumnTypeName = void 0;
const columnTypeNames = [
    'boolean',
    'enum',
    'short',
    'integer',
    'reference',
    'integerRange',
    'decimalRange',
    'date',
    'dateRange',
    'datetimeRange',
    'time',
    'datetime',
    'float',
    'decimal',
    'double',
    'binaryStream',
    'textStream',
    'string',
    'uuid',
    'byte',
    'binary',
    'json',
    'integerArray',
    'enumArray',
    'referenceArray',
    'stringArray',
];
function isColumnTypeName(name) {
    return columnTypeNames.includes(name);
}
exports.isColumnTypeName = isColumnTypeName;
// GraphQL has a limit to use 32-bit max and min Integer:
exports.MAX_INT_32 = 2 ** 31 - 1;
exports.MIN_INT_32 = -(2 ** 31);
//# sourceMappingURL=index.js.map