/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.TokenInvalidationService=void 0;const xtrem_access_token_1=require("@sage/xtrem-access-token"),loggers_1=require("./loggers"),logger=loggers_1.loggers.service,isLocalEnv=()=>!process.env.XTREM_ENV||"local"===process.env.XTREM_ENV;class TokenInvalidationService{static{this._isStarted=false}constructor(){}static start(e){if(this._isStarted)return;if(isLocalEnv())return void logger.warn("Cannot start token invalidation service: 'XTREM_ENV' environment variable not set or set to 'local'");if(false===e.security?.services?.tokenInvalidation?.active)return void logger.warn("Cannot start token invalidation service: Deactivated by config");if(!e.security?.loginUrl)return void logger.error("Cannot start token invalidation service: Login service must be configured - Missing 'loginUrl'");if(!e.clusterId)return void logger.error("Cannot start token invalidation service: Cluster Id is missing");try{(0,xtrem_access_token_1.getInvalidatedTokenInstance)().startListening({logger,tableName:process.env.XTREM_INVALIDATED_TOKEN_TABLE_NAME||"invalidated-token-table-name",frequencyInSec:15,cluster:e.clusterId}),this._isStarted=true,logger.info("Token invalidation service started")}catch(e){logger.error(`Cannot start token invalidation service: ${e.message}`)}}static stop(){if(!this._isStarted)return;(0,xtrem_access_token_1.getInvalidatedTokenInstance)().stopListening(),logger.info("Token invalidation service stopped")}static isInvalidatedToken(e){if(!this._isStarted)return false;return!e.jti||!(0,xtrem_access_token_1.getInvalidatedTokenInstance)().isJTIValid(e.jti)}}exports.TokenInvalidationService=TokenInvalidationService;
//# sourceMappingURL=token-invalidation.js.map