/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.startApplication=void 0;const xtrem_bytenode_1=require("@sage/xtrem-bytenode"),xtrem_core_1=require("@sage/xtrem-core"),graphql_endpoint_1=require("./endpoints/graphql-endpoint"),interop_endpoint_1=require("./endpoints/interop-endpoint"),metrics_endpoint_1=require("./endpoints/metrics-endpoint"),loggers_1=require("./loggers"),token_invalidation_1=require("./token-invalidation"),logger=loggers_1.loggers.service;function logApplicationInfo(t){const e=xtrem_core_1.ConfigManager.current;logger.info(`Deployment mode is ${e.deploymentMode}`),logger.info("Framework packages:"),t.getPlatformPackages().forEach(t=>{logger.info(`\t- ${t.name}: ${t.version}`)}),logger.info("Application packages:"),t.getPackages().forEach(t=>{logger.info(`\t- ${t.name}: ${t.packageJson.version}`)}),logger.info("Start options:"),Object.keys(t.startOptions).forEach(e=>{logger.info(`\t${e}: ${t.startOptions[e]}`)})}function canStartHealthMonitoring(t){const e=xtrem_core_1.ConfigManager.current;return!e.storage?.managedExternal&&"@sage/xtrem-communication"!==t.startOptions.services.join()}function startContainerHeartbeatMonitor(t){if(canStartHealthMonitoring(t))xtrem_core_1.ContainerHeartbeatMonitor.activateHeartbeatPublications(t),xtrem_core_1.ContainerHeartbeatMonitor.activate()}function startAppsHealthCheckMonitor(t){if(canStartHealthMonitoring(t))xtrem_core_1.InteropAppHealthMonitor.start()}function startUnhandledErrorMonitor(){const t=xtrem_core_1.ConfigManager.current;xtrem_core_1.unhandledErrorMonitor.start(t.errorMonitoringInterval,t.errorMonitoringThreshold)}async function startPackageServices(t){if(xtrem_core_1.ConfigManager.current.storage?.managedExternal)return;const e=t.servicePackagesStarted;await(0,xtrem_core_1.asyncArray)(e.filter(e=>t.startOptions.services.includes(e.name))).forEach(async e=>{if(e.api.startService)logger.info(()=>`starting service ${e.name}`),await e.api.startService(t)})}async function startApplication(t){logApplicationInfo(t),startUnhandledErrorMonitor(),startContainerHeartbeatMonitor(t),startAppsHealthCheckMonitor(t);const e=graphql_endpoint_1.GraphqlEndpoint.create(t);await startPackageServices(t),await e.start(),await(interop_endpoint_1.InteropEndpoint.create(t)?.start()),await(metrics_endpoint_1.MetricsEndpoint.create(t)?.start()),t.setReady()}Error.stackTraceLimit=100,(0,xtrem_bytenode_1.sourceMapSetup)(),process.on("SIGINT",()=>{token_invalidation_1.TokenInvalidationService.stop(),console.error(`process ${process.pid} killed by SIGINT`),process.exit(1)}),exports.startApplication=startApplication;
//# sourceMappingURL=start-application.js.map