/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.configureHelmetApp=void 0;const xtrem_core_1=require("@sage/xtrem-core"),xtrem_shared_1=require("@sage/xtrem-shared"),helmet_1=require("helmet"),_=require("lodash"),loggers_1=require("../loggers"),logger=loggers_1.loggers.service,defaultPendoSubscriptionId="5069687185997824",wellKnownUrl={pendo:"https://cdn.pendo.io",pendoStaticStorage:"https://pendo-io-static.storage.googleapis.com",pendoSubIdStaticStorage:"https://pendo-static-{{SUB_ID}}.storage.googleapis.com",pendoApp:"https://app.pendo.io",pendoData:"https://data.pendo.io",sageIdStaging:"https://id-shadow.sage.com",sageIdProd:"https://id.sage.com",sageFontCdn:"https://fonts.sage.com",newRelic:"https://bam.nr-data.net",newRelicCdn:"https://js-agent.newrelic.com",youTube:"https://www.youtube.com"};function configureHelmetApp(e){const t=xtrem_core_1.ConfigManager.current,n=t.documentationServiceUrl?new URL(t.documentationServiceUrl).origin:"",o=t.s3Storage?.s3BucketUrlPrefix,r=t.security,l=r?.redirectUrl?new URL(r.redirectUrl):null,s=r?.loginUrl?new URL(r?.loginUrl).origin:"",i=r?.renewalUrl?new URL(r?.renewalUrl).origin:"",c=r?_.uniq([s,s.replace("http://","https://"),i,i.replace("http://","https://")].filter(e=>!!e)):[];if(t.chatbotBackendUrl)c.push(new URL(t.chatbotBackendUrl).origin);if(l)if(c.push(`wss://websocket.${l.hostname.split(".").slice(1).join(".")}`),(0,xtrem_shared_1.isDevelopmentProdUiConfig)(t))c.push(`ws://websocket.${l.hostname.split(".").slice(1).join(".")}:8240`);if(o)c.push(o);const a=r?.services?.helmet,p=!a?.disabledOptions?.csp;if(!p)logger.warn("Helmet: CSP (Content Security Policy) is disabled");const d="https:"===l?.protocol&&!a?.disabledOptions?.hsts?a?.hsts||true:false;if(!d)logger.warn("Helmet: HSTS (HTTP Strict Transport Security) is disabled");const u=helmet_1.default.contentSecurityPolicy.getDefaultDirectives(),w=wellKnownUrl.pendoSubIdStaticStorage.replace("{{SUB_ID}}",t.pendo?.subscriptionId||defaultPendoSubscriptionId),g=["'self'","data:",wellKnownUrl.pendo,wellKnownUrl.pendoStaticStorage,w,wellKnownUrl.pendoApp],h={scriptSrc:["'unsafe-eval'","'unsafe-inline'",...g,w,wellKnownUrl.pendoData,wellKnownUrl.sageIdStaging,wellKnownUrl.sageIdProd,wellKnownUrl.newRelic,wellKnownUrl.newRelicCdn],imgSrc:[...g,w,wellKnownUrl.pendoData,wellKnownUrl.youTube],styleSrc:["'unsafe-inline'",...g,wellKnownUrl.sageFontCdn],objectSrc:["'self'","blob:"],frameSrc:[...g,s,n,wellKnownUrl.youTube,"blob:"],connectSrc:["'self'","blob:",wellKnownUrl.pendoApp,wellKnownUrl.pendoData,w,wellKnownUrl.newRelic,...c],childSrc:["'self'",wellKnownUrl.pendoApp],upgradeInsecureRequests:d?u["upgrade-insecure-requests"]:null},U=a?.csp?.directives||{};Object.entries(U).forEach(([e,t])=>{if(null==t)return;h[e]=[...h[e]||[],...t]});const f=_.cloneDeep(h),cspMiddleware=(e,t,n)=>{helmet_1.default.contentSecurityPolicy({useDefaults:true,directives:f})(e,t,n)};if(e.use((0,helmet_1.default)({strictTransportSecurity:d,contentSecurityPolicy:p,hidePoweredBy:true})),p)e.use(cspMiddleware)}exports.configureHelmetApp=configureHelmetApp;
//# sourceMappingURL=helmet-middleware.js.map