/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.configMiddleware=void 0;const xtrem_core_1=require("@sage/xtrem-core"),error_handlers_1=require("./error-handlers"),logger=xtrem_core_1.Logger.getLogger(__filename,"config");function parseScopes(e,r){logger.verbose(()=>["x-api-app-id","x-api-app-name","x-api-scope","x-api-base-url"].map(e=>`${e}=${JSON.stringify(r.header(e))}`).join(" "));const o=e.scope||r.header("x-api-scope")||r.header("x-mindo-scope");if(o&&/\ball:readonly\b/i.test(o.toString())){if(e.storage&&!e.storage.managedExternal&&!e.storage.sql)throw new Error("SQL config missing");e.graphql=e.graphql||{},e.graphql.isReadonly=true,logger.info(()=>"request is configured in read-only mode")}}function acceptService(e,r,o){if(!e.scope)return true;if(!r.url.split("/")[1])return(0,error_handlers_1.badRequest)(r,o),false;return true}function processConfig(e,r,o,i){if(logger.verbose(()=>`email=${JSON.stringify(e.email)} scope=${JSON.stringify(e.scope)} `),parseScopes(e,r),acceptService(e,r,o))i()}function processLocalConfig(e){return e.locals.config={...xtrem_core_1.ConfigManager.current,...e.locals.context},e.locals.config}const configMiddleware=(e,r,o)=>{if(/^\/ping$/.test(e.path))return void o();processConfig(processLocalConfig(r),e,r,o)};exports.configMiddleware=configMiddleware;
//# sourceMappingURL=config-middleware.js.map