/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.authMiddleware=void 0;const xtrem_core_1=require("@sage/xtrem-core"),xtrem_shared_1=require("@sage/xtrem-shared"),axios_1=require("axios"),jwt=require("jsonwebtoken"),jwksClient=require("jwks-rsa"),token_invalidation_1=require("../token-invalidation"),error_handlers_1=require("./error-handlers"),auth0WebUserPrefix="auth0",auth0ApiPrefix="api",isNewrelicDisabled="true"!==process.env.NEW_RELIC_ENABLED,logger=xtrem_core_1.Logger.getLogger(__filename,"auth");function extractToken(e){if(!e||e.length<8)return null;if(0!==e.indexOf("Bearer "))return null;const t=/^Bearer\s+([a-zA-Z0-9_-]+\.[a-zA-Z0-9_-]+\.[a-zA-Z0-9_-]+)/.exec(e);return t&&t[1]}function redirectToLogin(e,t,r){if(e.accepts("html")){if(!r.loginUrl)throw new Error("Cannot redirect: no login URL configured");const e=r.redirectUrl?`?fromUrl=${encodeURIComponent(r.redirectUrl)}`:"";return void t.redirect(`${r.loginUrl}${e}`)}(0,error_handlers_1.unauthorized)(e,t)}const authMiddleware=async(e,t,r)=>{const n=xtrem_core_1.ConfigManager.current,{security:o}=n;if(t.locals.auth={},(0,xtrem_shared_1.isDevelopmentConfig)(n)){if((0,xtrem_shared_1.isEnvVarTrue)(process.env.UNSECURE_DEV_LOGIN)){if("/unsecuredevlogin"===e.path){if(!e.query.user||!e.query.tenant)return unauthorizedError("user and tenant are mandatory for unsecure dev login",e,t);t.locals.auth={login:e.query.user,tenantId:e.query.tenant},t.cookie("access_token",`${e.query.tenant}_${t.locals.auth.login}`),t.cookie("access_token_sign",`${e.query.tenant}_${t.locals.auth.login}`);const r=e.get("host");if(r)t.location(`${e.protocol}://${r}`),t.status(302);return t.send()}const{access_token:r,access_token_sign:n}=e.cookies;if(r&&n&&r===n){const[e,n]=r.split("_");t.locals.auth={login:n,tenantId:e}}else if(e.headers.authorization){const r=/^Basic\s+(.*)/.exec(e.headers.authorization||"");if(r){const n=Buffer.from(r[1],"base64").toString();if(n)t.locals.auth={login:n.split(":")[0],tenantId:e.cookies.access_token.split("_")[0]}}}}if(n.auth)t.locals.auth.login??=n.auth?.login,t.locals.auth.tenantId??=n.auth?.tenantId,t.locals.auth.auth0??=n.auth?.auth0;else t.locals.auth.login??=n.user??xtrem_core_1.Test.defaultEmail,t.locals.auth.tenantId??=n.tenantId??xtrem_core_1.Test.defaultTenantId;const r=t.locals.auth.login;if(t.locals.context={email:r,tenantId:t.locals.auth.tenantId},r){const e=/^api-(\w+)@((?:[a-zA-Z0-9-]+\.)+[a-zA-Z]{2,7})$/.exec(r);t.locals.context.auth0=e?`api|${e[1]}`:"auth0|7bda53083aef4b4780ecbb73a318a966"}sharpenNewrelicContext(auth0WebUserPrefix,t.locals.auth.tenantId,t.locals.context.auth0,e.headers);const o=`xtrem_${t.locals.auth.tenantId}_persona`;if(e.cookies[o])t.locals.auth.persona=e.cookies[o]}if(!o||shouldIgnoreAuthentication(e,o))return r();try{const{token:a,auth0Type:i}=await verifyAuth(o,e);if(!a){if(e.accepts("html")){if(!o.loginUrl)throw new Error("Cannot redirect: no login URL configured");return redirectToLogin(e,t,o)}throw new Error("no token")}else{if(token_invalidation_1.TokenInvalidationService.isInvalidatedToken(a))throw new Error("token has been invalidated");if(verifyTokenClaims(a,n),o.enableAutoRefresh&&e.accepts("html"))await tryAutoRefeshToken(a,o,e,t);if(!a.pref&&a.auth0&&i===auth0WebUserPrefix)return redirectToLogin(e,t,o);t.locals.context={email:a.sub,tenantId:a.tenantId,pref:a.pref},t.locals.auth={...t.locals.auth,login:a.sub,tenantId:a.tenantId,auth0:a.auth0},sharpenNewrelicContext(i,a.tenantId||"unknown",a.auth0,e.headers);const s=`xtrem_${t.locals.context.tenantId}_persona`;if(e.cookies[s])t.locals.auth.persona=e.cookies[s];return r()}}catch(r){if(o.loginUrl&&e.accepts("html")&&r instanceof jwt.JsonWebTokenError){if(r instanceof jwt.TokenExpiredError||/^jwt audience invalid\./i.test(r.message))return logger.warn(`Redirecting to ${o.loginUrl} request ${e.method} ${e.url} [${r.message}]`),t.redirect("GET"===e.method?302:307,o.loginUrl)}return unauthorizedError(r.message,e,t)}};function shouldIgnoreAuthentication(e,t){const r=/^\/(ping)$/.test(e.path)||/^\/login-service$/.test(e.path);return!t?.loginUrl||r}function sharpenNewrelicContext(e,t,r,n){if(isNewrelicDisabled)return;const o=n["cf-ray"],a={tenantId:t,requestOrigin:getNewRelicSourceFromAuth0Type(e),cfRay:o};if(e===auth0ApiPrefix&&r){const e=r.split("|");if(e.length>=2)a.developerId=e[1];else logger.warn(`Unable to extract the develpperId from an api gateway call, auth0field is : ${r}`),a.developerId="unknown"}require("newrelic").addCustomAttributes(a)}function getNewRelicSourceFromAuth0Type(e){if(!e)return"unknown";switch(e){case auth0WebUserPrefix:return"webuser";case auth0ApiPrefix:return"apigateway";default:return logger.warn(`unknown source for newrelic request context : ${e}`),"unknown"}}function unauthorizedError(e,t,r){return(0,xtrem_core_1.logSecurityAlert)(t,"unauthorized",e),(0,error_handlers_1.unauthorized)(t,r)}async function verifyAuth(e,t){const r={authHeader:t.headers.authorization};let n;if(r.authHeader){if(r.authScheme=r.authHeader.split(" ")[0],n=extractToken(r.authHeader),!n)throw new Error(`Invalid token: authorization scheme ${r.authScheme}`)}else if(t.cookies.access_token&&t.cookies.access_token_sign)n=`${t.cookies.access_token}.${t.cookies.access_token_sign}`;else return{};if(3!==n?.split(".").length)throw new Error("Invalid token: must contain 3 segments");if(r.token=await verifyAuthToken(n,e),r.auth0Type=(r.token.auth0||"").split("|")[0],r.authHeader){if(r.auth0Type!==auth0ApiPrefix)throw new Error(`Bearer authentication expects an api token, got '${r.token.auth0}'`)}else if(r.auth0Type===auth0ApiPrefix)throw new Error(`Cookie authentication cannot use an api token, got '${r.token.auth0}'`);return r}let cachedClient;function getJwksClient(e){if(!cachedClient){if(!e)throw new Error("missing 'jwksUrl' value in security config");cachedClient=jwksClient({cache:true,jwksUri:e||""})}return cachedClient}function verifyAuthToken(e,t){const{issuer:r,audience:n,jwksUrl:o}=t,a=(()=>{const e=getJwksClient(o);return(t,r)=>e.getSigningKey(t.kid,(e,t)=>{if(e)r(e);else r(null,t.getPublicKey())})})(),i={issuer:r,algorithm:"RS256",audience:n};return new Promise((t,r)=>{jwt.verify(e,a,i,(e,n)=>{if(e)r(e);else t(n)})})}async function tryAutoRefeshToken(e,t,r,n){const o=null==e.exp?-1:e.exp-Math.floor(Date.now()/1e3),a=t.renewalThreshold||300;if(o>=0&&o<a&&r.cookies.refresh_token&&r.cookies.refresh_token_sign){const e={timeout:500,headers:{"x-refresh-token":`${r.cookies.refresh_token}.${r.cookies.refresh_token_sign}`,"x-access-token":`${r.cookies.access_token}.${r.cookies.access_token_sign}`,connection:"Keep-Alive"}};try{const r=t.renewalUrl||`${t.loginUrl}/renew`,o=(await axios_1.default.get(r,e)).headers["set-cookie"].filter(e=>/^(?:access|refresh)_token(?:_sign)?=/.test(e));n.set("set-cookie",o)}catch(e){logger.error(`Failed to auto-refresh token: ${e.message}`)}}}function verifyTokenClaims(e,t){const{security:r,app:n}=t;if(!n)return true;if(!e.app)throw new Error("token does not contain app claim");if(!e.apps)throw new Error("token does not contain apps claim");if(!e.apps.includes(n))throw new Error(`token is not valid for app '${n}'`);if(e.aud!==r?.audience)throw new Error(`jwt audience invalid. It does not match security config, expected: ${r?.audience}, got: ${e.aud}`);return true}exports.authMiddleware=authMiddleware;
//# sourceMappingURL=auth-middleware.js.map