import { Application } from '@sage/xtrem-core';
import { Express } from 'express';
import { HttpEndpoint, HttpEndpointConfig } from './http-endpoint';
/**
 * Represents an endpoint for handling metrics.
 */
export declare class MetricsEndpoint extends HttpEndpoint {
    /**
     * Configures the Express app with the necessary middleware and routes for metrics and health checks.
     *
     * @param expressApp - The Express app instance.
     */
    configureExpressApp(expressApp: Express): void;
    /**
     * Retrieves the configuration for the metrics endpoint.
     * @returns The HTTP endpoint configuration or undefined if the metrics endpoint is disabled.
     */
    static getConfig(application: Application): HttpEndpointConfig | undefined;
    /**
     * Creates a new MetricsEndpoint instance.
     *
     * @param application - The application instance.
     * @returns A MetricsEndpoint instance if the endpoint is enabled, otherwise undefined.
     */
    static create(application: Application): MetricsEndpoint | undefined;
}
//# sourceMappingURL=metrics-endpoint.d.ts.map