"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const AWSSecretWrapper_1 = require("./AWSSecretWrapper");
const localWrapper_1 = require("./localWrapper");
class SecretHandler {
    constructor(config, secretsManagerMock) {
        this.isLocal = false;
        this.isLocal = process.env.XTREM_ENV === "local" || !config || false;
        if (this.isLocal) {
            console.log("SecretHandler module is running locally");
            this.secretWrapper = new localWrapper_1.default();
        }
        else {
            console.log("SecretHandler module is using secrets library");
            if (config && (!config.xtremEnv || config.xtremEnv.length === 0)) {
                config.xtremEnv = process.env.XTREM_ENV || "dev-eu";
            }
            if (!config) {
                throw new Error("No configuration has been provided");
            }
            this.secretWrapper = new AWSSecretWrapper_1.default(config, secretsManagerMock);
        }
    }
    static checkParametersForNullOrBlank(param, paramName) {
        if (!param || param === "") {
            throw new Error(paramName + " cannot be empty");
        }
    }
    async getTenantEncryptionKey(tenantId) {
        SecretHandler.checkParametersForNullOrBlank(tenantId, "tenant id");
        return this.secretWrapper.getTenantEncryptionKey(tenantId);
    }
    /***
     * parse configuration value and retrive the aws secret if starting by @secret/ or pass back the original
     * value if not
     * @param configValue
     */
    async getConfigSecretValue(configValue) {
        return this.secretWrapper.readConfigValue(configValue);
    }
}
exports.default = SecretHandler;
