/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true});const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),xtrem_config_1=require("@sage/xtrem-config"),chai_1=require("chai"),database_service_1=require("../lib/database-service"),setup_1=require("./fixtures/setup");(0,chai_1.use)(require("chai-as-promised")),(0,setup_1.setup)();const storage={...xtrem_config_1.ConfigManager.current.storage},customConfig={user:"xtrem_user_test",database:"xtrem_database_test",schemaName:"xtrem_schema_test"};storage.sql={...storage.sql,...customConfig};const sqlConfig=storage.sql,databaseOptions={encoding:"UTF8",lcCollate:"und-x-icu",lcCtype:"und-x-icu",connectionLimit:-1,template:"template0",tableSpaceName:"pg_default"};async function withTestDatabaseService(a,e){const s=database_service_1.DatabaseService._service;try{database_service_1.DatabaseService._service=null,await e(database_service_1.DatabaseService.getInstance(a))}finally{database_service_1.DatabaseService._service=s}}describe("Database Create",()=>{if(!sqlConfig.sysUser)return void it.skip("Test skipped on pool. sysUser missing.",()=>{});it("Create / Drop Database with default options",()=>withTestDatabaseService(sqlConfig,async a=>{await a.createDatabaseIfNotExists(),chai_1.assert.isTrue(await a.databaseExists(sqlConfig.database));const e=a.sysPool;chai_1.assert.isDefined(e),await a.dropDatabaseIfExists(),chai_1.assert.isFalse(await a.databaseExists(sqlConfig.database))})),it("Throws an error if database does not exist",()=>withTestDatabaseService(sqlConfig,async a=>{await chai_1.assert.isRejected(a.checkThatDatabaseExists(),"Database not created yet")})),it("Throws an error if sysUser does not exist",async()=>{const a={...sqlConfig};delete a.sysUser,await withTestDatabaseService(a,a=>chai_1.assert.throw(()=>{a.sysPool},"invalid config: sysUser config missing."))}),it("Throws an error if sysDatabase does not exist",async()=>{const a={...sqlConfig};delete a.sysDatabase,await withTestDatabaseService(a,a=>chai_1.assert.throw(()=>{a.serverPool},"invalid config: sysDatabase config missing."))}),it("Check database parameters",()=>withTestDatabaseService(sqlConfig,async a=>{await a.createDatabaseIfNotExists(),chai_1.assert.isTrue(await a.databaseExists(sqlConfig.database));const e=await a.serverPool.withConnection(async e=>(await a.serverPool.execute(e,'SELECT c.datname as name, c.datconnlimit as "connectionLimit"\n                    FROM pg_database c WHERE c.datname = $1',[sqlConfig.database]))[0]);chai_1.assert.deepEqual(e,{name:sqlConfig.database,connectionLimit:databaseOptions.connectionLimit}),await a.dropDatabaseIfExists(),chai_1.assert.isFalse(await a.databaseExists(sqlConfig.database))})),it("Check missing config",()=>{const a={...sqlConfig};return delete a.sysPassword,withTestDatabaseService(a,a=>{chai_1.assert.throw(()=>{a.sysPool},"invalid config: sysPassword config missing.")})}),it("Security Check - SQL Injection for Space and Special characters",async()=>{await(0,xtrem_async_helper_1.asyncArray)(["hack sysUser","hack.[]{}()<>*+-=!?^$|sysUser"]).forEach(a=>withTestDatabaseService({...sqlConfig,sysUser:a},e=>chai_1.assert.throw(()=>{e.sysPool},`Invalid sysUser value: '${a}'.`))),await(0,xtrem_async_helper_1.asyncArray)(["hack user","hack.[]{}()<>*+-=!?^$|user"]).forEach(a=>withTestDatabaseService({...sqlConfig,user:a},e=>chai_1.assert.throw(()=>{e.userPool},`Invalid user value: '${a}'.`))),await(0,xtrem_async_helper_1.asyncArray)(["hack database","hack.[]{}()<>*+-=!?^$|database"]).forEach(a=>withTestDatabaseService({...sqlConfig,database:a},e=>chai_1.assert.throw(()=>{e.sysPool},`Invalid database value: '${a}'.`)))}),it("can timeout statement",async()=>{const a={...sqlConfig,statementTimeoutMillis:1e3};await withTestDatabaseService(a,async a=>{await a.createDatabaseIfNotExists(),chai_1.assert.isTrue(await a.databaseExists(sqlConfig.database));const e=a.serverPool;chai_1.assert.isDefined(e),await chai_1.assert.isRejected(e.withConnection(a=>e.execute(a,"SELECT pg_sleep(2)")),"canceling statement due to statement timeout")})}),after(()=>withTestDatabaseService(sqlConfig,a=>a.dropDatabaseIfExists()))});
//# sourceMappingURL=database-test.js.map