// From file: /agent/_work/1/s/platform/back-end/xtrem-postgres/build/index.d.ts
declare module '@sage/xtrem-postgres/index' {
	/** @module @sage/xtrem-postgres */
	export { PoolClient } from 'pg';
	export * from '@sage/xtrem-postgres/lib/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-postgres/build/lib/types.d.ts
declare module '@sage/xtrem-postgres/lib/types' {
	import { ColumnTypeName, Dict, LogLevel, ProfilerCallback, TlsConnectionOptions } from '@sage/xtrem-shared';
	import * as postgres from 'pg';
	import { ColumnJsonComment, ForeignKeyJsonComment, TableJsonComment } from '@sage/xtrem-postgres/lib/json-comment';
	export { DatabaseError } from 'pg-protocol';
	export { ColumnTypeName };
	/**
	 * A marker to not convert a literal in the SQL converter, as it is not required, e.g. NOW(), currval((pg_get_serial_sequence('foo'))
	 */
	export const dbCommandMarker = "%%DB_COMMAND%%";
	export type Connection = postgres.PoolClient;
	/**
	 * The precision for the decimal columns - whatever the precision is in the property decorator, decimal columns are stored as (28,10)
	 */
	export const decimalColumnPrecision = 28;
	/**
	 * The scale for the decimal columns - whatever the precision is in the property decorator, decimal columns are stored as (28,10)
	 */
	export const decimalColumnScale = 10;
	export interface SqlExecuteOptions {
	    decimalColumns?: string[];
	    fetchInfo?: any;
	    outputVars?: SqlColumnDesc[];
	    pageSize?: number;
	    /**
	     * Are unsafe SQL queries allowed ?
	     * An unsafe query can contain the ' character (which could be used for SQL injections)
	     */
	    allowUnsafe?: boolean;
	}
	export interface PostgresSqlExecuteOptions extends SqlExecuteOptions {
	    logLevel?: LogLevel;
	}
	export interface PostgresPoolReaderOptions extends PoolReaderOptions {
	    logLevel?: LogLevel;
	    pageSize?: number;
	}
	export interface CopyOptions {
	    to?: string;
	    format?: 'csv';
	    delimiter?: string;
	    header?: boolean;
	    headers?: string[];
	}
	export interface SqlColumnDesc {
	    name?: string;
	    type?: string;
	    typtyp?: number;
	}
	export interface SqlColumnInfo {
	    name?: string;
	    type?: number;
	    typtyp?: number;
	}
	export type SqlColumnsDesc = Dict<SqlColumnDesc>;
	type SqlTableSchemaElement = 'columns' | 'security' | 'indexes' | 'sequences' | 'foreignKeys' | 'triggers';
	export interface SqlReadTableSchemaOptions {
	    skipColumns?: boolean;
	    skipSecurity?: boolean;
	    skipIndexes?: boolean;
	    skipSequences?: boolean;
	    skipForeignKeys?: boolean;
	    includes?: SqlTableSchemaElement[];
	    /**
	     * Do we want to fetch the comments for the tables, columns, fks, ... ?
	     */
	    getComments?: boolean;
	    $diagnoses?: {
	        $severity: string;
	        $message: string;
	    }[];
	}
	export interface SqlCreateTableOptions {
	    isAltering?: boolean;
	    skipCommands?: boolean;
	    onlyIndexes?: boolean;
	    skipDrop?: boolean;
	    skipCreate?: boolean;
	    skipSequences?: boolean;
	    skipIndexes?: boolean;
	    /**
	     * Should the DEFAULT clause(s) be skipped when creating table/columns ?
	     */
	    skipDefault?: boolean;
	    dropTrigger?: boolean;
	    skipTriggers?: boolean;
	    skipGrant?: boolean;
	    skipForeignKeys?: boolean;
	    skipConstraints?: boolean;
	    temp?: boolean;
	    hasNotifyTriggers?: boolean;
	    deferredSql?: DeferredSql;
	}
	export interface DeferredSql {
	    alterColumns?: string[];
	    updateColumns?: string[];
	}
	export interface EnumType {
	    name: string;
	    values: Dict<number>;
	}
	export interface ColumnDefinition {
	    name: string;
	    maxLength?: number;
	    isNullable?: boolean;
	    default?: string | null;
	    colType?: string;
	    type?: ColumnTypeName;
	    /** Is this a system column ? (_update_tick, ...) */
	    isSystem?: boolean;
	    /** Is this column auto-increment ? (i.e.: the value is assigned by the database engine when inserting) */
	    isAutoIncrement?: boolean;
	    /** is this column a non nullable self reference? */
	    isSelfReference?: boolean;
	    precision?: number;
	    scale?: number;
	    useFloatingPointFormat?: boolean;
	    loadPath?: string;
	    enumDataType?: EnumType;
	    /** Is property value an encrypted string ? (only applies to string properties) */
	    isEncryptedString?: boolean;
	    /**
	     * The comment of the SQL object (JSON format)
	     */
	    comment?: ColumnJsonComment;
	}
	export interface Hint {
	    tname: string;
	    abbrev: string;
	    revert: boolean;
	    name?: string;
	    nohint?: boolean;
	}
	export interface Record {
	    [name: string]: any;
	}
	export type TypedRecord<T> = Record & T;
	export interface IndexColumn {
	    name: string;
	    ascending?: boolean;
	    expression?: string;
	}
	export interface IndexDefinition {
	    name: string;
	    isUnique: boolean;
	    isNaturalKey?: boolean;
	    columns: IndexColumn[];
	}
	/**
	 * The behaviour of a foreign key on 'delete' operation
	 */
	export type ForeignKeyDeleteBehaviour = 
	/**
	 * ON DELETE CASCADE
	 */
	'cascade'
	/**
	 * ON DELETE RESTRICT
	 */
	 | 'restrict'
	/**
	 * ON DELETE NO ACTION
	 */
	 | 'noAction';
	export interface ForeignKeyDefinition {
	    /**
	     * The name of the FK
	     */
	    name: string;
	    /**
	     * The name of the target table
	     */
	    targetTable: string;
	    /**
	     * The name of the target columns (from the target table)
	     */
	    targetColumnNames: string[];
	    /**
	     * The name of the columns (from the current table)
	     */
	    columnNames: string[];
	    /**
	     * The behaviour of the foreign key on 'delete' operation
	     */
	    onDeleteBehaviour: ForeignKeyDeleteBehaviour;
	    /**
	     * The comment of the SQL object (JSON format)
	     */
	    comment?: ForeignKeyJsonComment;
	    /**
	     * Is the foreign key DEFERRABLE ?
	     */
	    isDeferrable: boolean;
	}
	/**
	 * Parses a foreignKey definition to extract source/target columns
	 * The key definition is a result from pg_catalog.pg_get_constraintdef
	 */
	export function parseForeignKeyDefinition(fkDef: string): {
	    sourceColumns: string[];
	    targetColumns: string[];
	    onDeleteBehaviour: ForeignKeyDeleteBehaviour;
	    isDeferrable: boolean;
	};
	export interface ForeignKeyOptions {
	    /**
	     * Will be used in the flag that the query that checks if the foreign key exists should be skipped.
	     */
	    skipExists?: boolean;
	    skipBaseTable?: boolean;
	    /**
	     * Should the foreign key be created in 'UPDATE CASCADE' mode ?
	     */
	    withUpdateCascade?: boolean;
	    /**
	     * Should the missing foreign keys be created ?
	     */
	    dontCreateMissingFks?: boolean;
	}
	interface PrimaryKeyDefinition {
	    columns: string[];
	}
	export interface NotifyOptions {
	    event: NotifyEventOptions;
	    sqlPayloadExpression?: string;
	}
	export interface NotifyEventOptions {
	    created?: boolean;
	    updated?: boolean;
	    deleted?: boolean;
	}
	export interface TableDefinition {
	    schemaName: string;
	    tableName: string;
	    columns?: ColumnDefinition[];
	    indexes?: IndexDefinition[];
	    primaryKey?: PrimaryKeyDefinition;
	    foreignKeys?: ForeignKeyDefinition[];
	    triggers?: TriggerDefinition[];
	    notify?: NotifyOptions;
	    isOpenAccess?: boolean;
	    sequence?: number;
	    lastUpdate?: Date;
	    isSharedByAllTenants?: boolean;
	    baseDefinition?: TableDefinition;
	    /**
	     * The comment of the SQL object (JSON format)
	     */
	    comment?: TableJsonComment;
	}
	export type TriggerEventType = 'INSERT' | 'UPDATE' | 'DELETE' | 'TRUNCATE' | 'INSERT OR UPDATE' | 'DELETE OR INSERT' | 'DELETE OR INSERT OR UPDATE';
	export type TriggerTimingType = 'BEFORE' | 'AFTER' | 'INSTEAD OF';
	export interface TriggerDefinition {
	    /**
	     * name of the trigger
	     */
	    name: string;
	    /**
	     * When will the trigger get fired ? (before/after/...)
	     */
	    when: TriggerTimingType;
	    /**
	     * The event type (insert/update/...)
	     */
	    event: TriggerEventType;
	    /**
	     * The options of the trigger (if any)
	     */
	    options?: string;
	    /**
	     * The name of the function that the trigger will execute. Only the name of the function without any parameters
	     */
	    functionName: string;
	    /**
	     * The parameters for the function
	     */
	    functionParameters: string;
	}
	export interface TableFilter {
	    key: string;
	    operator: string;
	    value: any;
	}
	export interface PoolConfig {
	    connectString?: string;
	    hostname: string;
	    port?: number;
	    database: string;
	    trace?: (...args: any[]) => void;
	    user: string;
	    password: string;
	    requestTimeout?: number;
	    collation?: string;
	    privilege?: number;
	    /** Should all the $xx parameters be replaced by their value ? */
	    mapArgsInLogs?: boolean;
	    sysUser?: string;
	    sysPassword?: string;
	    sysDatabase?: string;
	    connectionMaxRetries?: number;
	    connectionRetryMillis?: number;
	    ssl?: boolean | TlsConnectionOptions;
	    idleTimeoutMillis?: number;
	    max?: number;
	    maxUses?: number;
	    connectionTimeoutMillis?: number;
	    /** Number of milliseconds before a statement in query will time out, default is no timeout. We will set the query timeout as 120% of this.
	     * https://node-postgres.com/apis/client
	     * https://stackoverflow.com/questions/59155572/how-to-set-query-timeout-in-relation-to-statement-timeout
	     */
	    statementTimeoutMillis?: number;
	    /** Size of the funnel that throttles connection allocation */
	    connectionAllocationFunnelSize?: number;
	}
	export interface DatabaseParametersType {
	    template: string;
	    encoding: string;
	    lcCollate: string;
	    lcCtype: string;
	    tableSpaceName: string;
	    connectionLimit: number;
	}
	export interface PoolLoggerInterface {
	    error(message: string): void;
	    warn(message: string): void;
	    info(message: string): void;
	    verbose(formatMessage: () => string): void;
	    log(logLevel: LogLevel, formatMessage: () => string): ProfilerCallback | undefined;
	}
	//# sourceMappingURL=types.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-postgres/build/lib/sql-recorder.d.ts
declare module '@sage/xtrem-postgres/lib/sql-recorder' {
	import { Dict } from '@sage/xtrem-shared';
	export type SqlRecorderActionType = 'reload_setup_data' | 'system_upgrade' | 'metadata_upgrade';
	/**
	 * This interface can be used to register a recorder to a PostgresPool.
	 * This recorder will be invoked on every executed command.
	 * The execution of the recorder.record function must be as fast as possible (or it will degrade performances)
	 */
	export interface SqlRecorder {
	    /**
	     * Executes a body where the recorder will be paused
	     * @param body
	     */
	    withoutRecording<T>(body: () => Promise<T>): Promise<T>;
	    /**
	     * Records a SQL command (and its arguments)
	     */
	    recordSqlCommand(command: string, args?: any[]): void;
	    /**
	     * Records an action
	     */
	    recordAction(action: SqlRecorderActionType, args?: Dict<string>): void;
	}
	//# sourceMappingURL=sql-recorder.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-postgres/build/lib/profiler.d.ts
declare module '@sage/xtrem-postgres/lib/profiler' {
	export {};
	//# sourceMappingURL=profiler.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-postgres/build/lib/pool.d.ts
declare module '@sage/xtrem-postgres/lib/pool' {
	/// <reference types="node" />
	/// <reference types="node" />
	/// <reference types="node" />
	/** @module @sage/xtrem-postgres */
	import { AnyValue, AsyncReader, AsyncResponse } from '@sage/xtrem-async-helper';
	import { LoggerInterface } from '@sage/xtrem-shared';
	import { EventEmitter } from 'node:events';
	import * as postgres from 'pg';
	import { SqlRecorder } from '@sage/xtrem-postgres/lib/sql-recorder';
	import { Connection, PoolConfig, PoolLoggerInterface, PostgresPoolReaderOptions, PostgresSqlExecuteOptions } from '@sage/xtrem-postgres/lib/types';
	import Pool = require('pg-pool');
	import copyStreams = require('pg-copy-streams');
	export const copyTo: typeof copyStreams.to;
	export const copyFrom: typeof copyStreams.from;
	export type CommonPool = Pick<Pool<postgres.Client>, 'connect' | 'on' | 'end'>;
	export interface DatabaseVersion {
	    text: string;
	    major: number;
	    minor: number;
	}
	export interface DatabaseSettings {
	    max_connections: number;
	    reserved_connections: number;
	    superuser_reserved_connections: number;
	    shared_buffers: string;
	}
	export interface DatabaseInfo {
	    version: DatabaseVersion;
	    settings: DatabaseSettings;
	}
	export interface ConnectionPoolSetupOptions {
	    logger: LoggerInterface;
	    metricsEmitter?: EventEmitter;
	}
	export type ConnectionPoolType = 'server' | 'sys' | 'user';
	export class ConnectionPool {
	    readonly type: ConnectionPoolType;
	    private readonly config;
	    private _user;
	    private _pool;
	    sqlRecorder?: SqlRecorder;
	    trace: (...args: any[]) => void;
	    constructor(type: ConnectionPoolType, config: PoolConfig);
	    get user(): string;
	    static logger: PoolLoggerInterface;
	    private static metricsEmitter;
	    private get stats();
	    static setup(options: ConnectionPoolSetupOptions): void;
	    private incrementRetryCounter;
	    private updateMetrics;
	    /**
	     * Return the max count of connection the pool can open concurrently
	     */
	    get poolSize(): number;
	    /**
	     * Returns the configuration used by the postgres pool
	     */
	    private get runtimeConfig();
	    private queryDatabaseInfo;
	    getUsablePoolSize(): Promise<number>;
	    private get pool();
	    /**
	     * Function to execute passed callback function passing the current allocated connection to the callback and then releasing the connection
	     * @param body
	     */
	    withConnection<T extends AnyValue | void>(body: (cnx: Connection) => AsyncResponse<T>, connection?: postgres.PoolClient): Promise<T>;
	    /**
	     * Returns a buffer reader for the supplied BLOB
	     * @param value
	     */
	    static readBlob(val: any): Promise<Buffer | null>;
	    /**
	     *  Returns a buffer reader for the supplied CLOB
	     * @param value
	     */
	    static readClob(val: any): Promise<string | null>;
	    /**
	     * Returns the relevant buffer reader for the supplied BLOB
	     * @param val
	     */
	    static blobReader(val: any): AsyncReader<Buffer>;
	    /**
	     *  Returns the relevant string reader for the supplied CLOB
	     * @param val
	     */
	    static clobReader(val: any): AsyncReader<string>;
	    onNotice: (notice: any) => void;
	    /**
	     * Gets the current database connection, if one does not exists then a connection is created
	     */
	    private _allocConnection;
	    /**
	     * Allocates a postgres connection.
	     *
	     * The allocation is throttled, to ensure that:
	     * - we don't exhaust the pool
	     * - concurrent requests are treated fairly.
	     *
	     * @param originId the originId of the request
	     * @returns a postgres connection promise
	     */
	    allocConnection(originId: string): Promise<Connection>;
	    /**
	     * Releases a postgres connection.
	     *
	     * This method MUST be used to release connections allocated by the allocConnection method.
	     *
	     * @param connection the connection
	     * @returns void
	     */
	    releaseConnection(connection: Connection): void;
	    private getProfiler;
	    /**
	     * Function that executes SQL command on the provided connection and with the provided arguments and options.
	     * @param cnx Database connection
	     * @param sql SQL command
	     * @param args SQL arguments
	     * @param opts SQL options
	     */
	    execute<T extends AnyValue | void>(cnx: Connection, sql: string, args?: any[], opts?: PostgresSqlExecuteOptions): Promise<T>;
	    private static convertArgs;
	    /**
	     * Creates a reader for the provided connection and SQL statement
	     * @param cnx
	     * @param sql
	     * @param args
	     * @param opts
	     */
	    createReader<T extends AnyValue>(cnx: Connection, sql: string, args: any[], opts?: PostgresPoolReaderOptions): AsyncReader<T>;
	    /**
	     * Release all database connections
	     */
	    release(): Promise<void>;
	}
	//# sourceMappingURL=pool.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-postgres/build/lib/json-comment.d.ts
declare module '@sage/xtrem-postgres/lib/json-comment' {
	import { Dict } from '@sage/xtrem-shared';
	import { ColumnTypeName, ForeignKeyDeleteBehaviour } from '@sage/xtrem-postgres/lib/types';
	export interface SqlObjectJsonComment {
	}
	/**
	 * Interface of a JSON comment for a SQL table
	 */
	export interface TableJsonComment extends SqlObjectJsonComment {
	    /**
	     * The base table
	     */
	    baseTable?: string;
	    /**
	     * The rootTable is the lowest abstract table of the subNode tree
	     *  cat->mammal->animal
	     * mammal will be the base table of cat
	     * animal will be the root table of cat
	     * for subNodes this is useful as this is the table that has the SERIAL _id column
	     */
	    rootTable?: string;
	    /**
	     * Does this table stand for a 'isSharedByAllTenants' factory ?
	     */
	    isSharedByAllTenants: boolean;
	    /**
	     * Natural key attributes
	     */
	    naturalKey?: string[];
	    /**
	     * Is this a setup node
	     */
	    isSetupNode?: boolean;
	}
	export type ColumnTypeJsonComment = ColumnTypeName | 'reference';
	/**
	 * Interface of a JSON comment for a SQL column
	 */
	export interface ColumnJsonComment extends SqlObjectJsonComment {
	    /**
	     * On reference columns: the name of the target table
	     */
	    targetTableName?: string;
	    /**
	     * On reference columns: is it a self-reference column ?
	     */
	    isSelfReference?: boolean;
	    /**
	     * The basic type of the column's property
	     */
	    type: ColumnTypeJsonComment;
	    /**
	     * Is it a system column ?
	     */
	    isSystem: boolean;
	    /**
	     * When type is 'json': is the column stands for a localized text (true) or a real JSON object (false) ?
	     */
	    isLocalized?: boolean;
	    /**
	     * When type is 'string': is the string encrypted ?
	     */
	    isEncrypted?: boolean;
	    /**
	     * When type is 'enum': the name of the enum
	     */
	    enumTypeName?: string;
	    /**
	     * When type is 'integer': is it an auto-increment column ?
	     */
	    isAutoIncrement?: boolean;
	    /**
	     * When type is 'string': max-length of the string
	     */
	    maxLength?: number;
	    /**
	     * When type is 'decimal': the precision of the column
	     */
	    precision?: number;
	    /**
	     * When type is 'decimal': the scale of the column
	     */
	    scale?: number;
	}
	/**
	 * Interface of a JSON comment for a SQL foreign key
	 */
	export interface ForeignKeyJsonComment extends SqlObjectJsonComment {
	    targetTableName: string;
	    /**
	     * A dictionary of the columns (sourceColumn:targetColumn) used by the foreign key :
	     */
	    columns: Dict<string>;
	    /**
	     * The behaviour of the foreign key on 'delete' operation
	     */
	    onDeleteBehaviour: ForeignKeyDeleteBehaviour;
	    /**
	     * Is the foreignKey deferrable ?
	     */
	    isDeferrable: boolean;
	}
	//# sourceMappingURL=json-comment.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-postgres/build/lib/index.d.ts
declare module '@sage/xtrem-postgres/lib/index' {
	export * from '@sage/xtrem-postgres/lib/database-service';
	export * from '@sage/xtrem-postgres/lib/json-comment';
	export * from '@sage/xtrem-postgres/lib/pool';
	export * from '@sage/xtrem-postgres/lib/sql-recorder';
	export * from '@sage/xtrem-postgres/lib/types';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-postgres/build/lib/database-service.d.ts
declare module '@sage/xtrem-postgres/lib/database-service' {
	import { ConnectionPool } from '@sage/xtrem-postgres/lib/pool';
	import { Connection, PoolConfig } from '@sage/xtrem-postgres/lib/types';
	export class DatabaseService {
	    readonly config: PoolConfig;
	    private _serverPool;
	    private _sysPool;
	    private _userPool;
	    private static _service;
	    private constructor();
	    static getInstance(config: PoolConfig): DatabaseService;
	    static getSysPool(config: PoolConfig): ConnectionPool;
	    static getPool(config: PoolConfig): ConnectionPool;
	    checkThatDatabaseExists(): Promise<void>;
	    /** Sys connections are privileged. Then can perform DDL operations in a database created by server connections */
	    get sysPool(): ConnectionPool;
	    /** User connections are non-privileged. They can only perform DML operations in tables created by sys connections */
	    get userPool(): ConnectionPool;
	    private validateAndFixConfig;
	    /**
	     * Create database
	     */
	    createDatabaseIfNotExists(): Promise<void>;
	    databaseExists(name: string): Promise<boolean>;
	    /**
	     * Create (if needed) the roles for 'user' and 'sysUser'
	     */
	    createUsers(cnx: Connection, user: string, password: string, sysUser?: string, sysPassword?: string): Promise<void>;
	    /**
	     * Create (if not existing) the sysUser
	     */
	    private createSysUser;
	    private userExists;
	    dropDatabaseIfExists(): Promise<void>;
	    /**
	     * Rename a schema in database
	     */
	    renameSchema(oldName: string, newName: string): Promise<void>;
	}
	//# sourceMappingURL=database-service.d.ts.map
}
declare module '@sage/xtrem-postgres' {
	export * from '@sage/xtrem-postgres/index';
}
