"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConsoleTransport = exports.colorizeText = void 0;
/* eslint-disable no-console */
const TransportStream = require("winston-transport");
const colors_1 = require("./colors");
const tripleBeamSymbols = require('triple-beam');
/** @internal */
function colorizeText(level, text) {
    /* istanbul ignore next */
    if (!process.stdout.isTTY) {
        return text;
    }
    switch (level) {
        case 'error':
            return colors_1.Colors.red(text);
        case 'warn':
            return colors_1.Colors.yellow(text);
        case 'verbose':
        case 'debug':
            return colors_1.Colors.lightBlue(text);
        default:
            return text;
    }
}
exports.colorizeText = colorizeText;
/** @internal */
class ConsoleTransport extends TransportStream {
    constructor(options = {}) {
        super(options);
    }
    log(info, callback) {
        global.setImmediate(() => this.emit('logged', info));
        if (info[tripleBeamSymbols.LEVEL] === 'error')
            console.error(info[tripleBeamSymbols.MESSAGE]);
        else
            console.log(info[tripleBeamSymbols.MESSAGE]);
        if (callback)
            callback();
    }
}
exports.ConsoleTransport = ConsoleTransport;
//# sourceMappingURL=console-transport.js.map