"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Colors = void 0;
var ColorEnum;
(function (ColorEnum) {
    ColorEnum[ColorEnum["black"] = 30] = "black";
    ColorEnum[ColorEnum["red"] = 31] = "red";
    ColorEnum[ColorEnum["green"] = 32] = "green";
    ColorEnum[ColorEnum["yellow"] = 33] = "yellow";
    ColorEnum[ColorEnum["blue"] = 34] = "blue";
    ColorEnum[ColorEnum["magenta"] = 35] = "magenta";
    ColorEnum[ColorEnum["cyan"] = 36] = "cyan";
    ColorEnum[ColorEnum["lightGray"] = 37] = "lightGray";
    ColorEnum[ColorEnum["default"] = 39] = "default";
    ColorEnum[ColorEnum["darkGray"] = 90] = "darkGray";
    ColorEnum[ColorEnum["lightRed"] = 91] = "lightRed";
    ColorEnum[ColorEnum["lightGreen"] = 92] = "lightGreen";
    ColorEnum[ColorEnum["lightYellow"] = 93] = "lightYellow";
    ColorEnum[ColorEnum["lightBlue"] = 94] = "lightBlue";
    ColorEnum[ColorEnum["lightMagenta"] = 95] = "lightMagenta";
    ColorEnum[ColorEnum["lightCyan"] = 96] = "lightCyan";
    ColorEnum[ColorEnum["white"] = 97] = "white";
})(ColorEnum || (ColorEnum = {}));
class Colors {
    static format(color, message) {
        return `\x1b[${color}m${message}\x1b[${ColorEnum.default}m`;
    }
    static black(message) {
        return Colors.format(ColorEnum.black, message);
    }
    static red(message) {
        return Colors.format(ColorEnum.red, message);
    }
    static green(message) {
        return Colors.format(ColorEnum.green, message);
    }
    static yellow(message) {
        return Colors.format(ColorEnum.yellow, message);
    }
    static blue(message) {
        return Colors.format(ColorEnum.blue, message);
    }
    static magenta(message) {
        return Colors.format(ColorEnum.magenta, message);
    }
    static cyan(message) {
        return Colors.format(ColorEnum.cyan, message);
    }
    static white(message) {
        return Colors.format(ColorEnum.white, message);
    }
    static lightGray(message) {
        return Colors.format(ColorEnum.lightGray, message);
    }
    static default(message) {
        return Colors.format(ColorEnum.default, message);
    }
    static darkGray(message) {
        return Colors.format(ColorEnum.darkGray, message);
    }
    static lightRed(message) {
        return Colors.format(ColorEnum.lightRed, message);
    }
    static lightGreen(message) {
        return Colors.format(ColorEnum.lightGreen, message);
    }
    static lightYellow(message) {
        return Colors.format(ColorEnum.lightYellow, message);
    }
    static lightBlue(message) {
        return Colors.format(ColorEnum.lightBlue, message);
    }
    static lightMagenta(message) {
        return Colors.format(ColorEnum.lightMagenta, message);
    }
    static lightCyan(message) {
        return Colors.format(ColorEnum.lightCyan, message);
    }
    /** Removes all the color markers from a string */
    static clean(message) {
        return message.replace(/\\x1b\[\d+m/g, '');
    }
}
exports.Colors = Colors;
//# sourceMappingURL=colors.js.map