/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.InfrastructureHelper=void 0;const async_context_provider_1=require("@sage/async-context-provider"),xtrem_core_1=require("@sage/xtrem-core"),xtrem_file_storage_1=require("@sage/xtrem-file-storage"),xtrem_infra_1=require("@sage/xtrem-infra"),fs=require("fs"),path=require("path");class InfrastructureHelper{static{this.logger=new xtrem_core_1.Logger(__filename,"infrastructure")}static getLogger(){if(this.logger)return this.logger;return this.logger=new xtrem_core_1.Logger(__filename,"infrastructure"),this.logger}static getAsyncContextXtremRepository(){const e=xtrem_core_1.ConfigManager.current;if("development"===e.deploymentMode){if(!this.testAsyncContextXtremRepository)this.testAsyncContextXtremRepository=async_context_provider_1.AsyncContextBuilder.getLocalDevImplementation();return this.testAsyncContextXtremRepository}if(!e.asyncContextTableName)throw new Error("Missing config: asyncContextTableName.");return async_context_provider_1.AsyncContextBuilder.getCloudImplementation({dynamoDBTableName:e.asyncContextTableName,awsConfigOverride:{region:e.aws?.region||process.env.AWS_REGION||"eu-west-1"}})}static getTenantId(e){if(!e.tenantId)throw new Error("Tenant ID is missing from context.");return e.tenantId}static getClusterId(){const e=xtrem_core_1.ConfigManager.current;if(e.clusterId)return e.clusterId;return"development"===e.deploymentMode?"development-cluster":e.clusterId||""}static async createAsyncContext(e,t,r,n){return this.getAsyncContextXtremRepository().createAsyncContext({cluster:this.getClusterId(),app:xtrem_core_1.ConfigManager.current.app,tenantId:this.getTenantId(e),contextKind:async_context_provider_1.ASYNC_CONTEXT_CONST[t],contextXtrem:{...r,user:(await e.user)?._id},expireDatetimeIso:n?.expireDatetimeIso,notifyTimeout:true,nanoId:n?.contextId,responseQueueName:n?.responseQueueName,s3FileTTL:n.s3FileTTL,contextInfra:{mimeType:n?.mimeType}})}static stripVoid(e){try{if(!e)return}catch{return}return e}static async getAsyncContext(e){const t=this.getAsyncContextXtremRepository(),r=await t.getAsyncContext(e);return this.stripVoid(r)}static deleteAsyncContext(e){return this.getAsyncContextXtremRepository().deleteAsyncContext(e)}static getFileStorageHandler(e){const t=this.getLogger(),r=xtrem_core_1.ConfigManager.current;if(r?.s3Storage?.localBasePath&&"development"!==xtrem_core_1.ConfigManager.current.deploymentMode)throw Error("localBasePath is allowed only in development mode");const n=(0,xtrem_file_storage_1.getFileStorageHandler)({bucket:r.s3Storage?.s3ClusterBucket,app:r.app,maxListFiles:1e3,awsConfigOverride:{region:r.aws?.region||process.env.AWS_REGION||"eu-west-1"},logger:t.info.bind(t),localBasePath:r?.s3Storage?.localBasePath||path.join(e.application.tmpDir)});if(e.testMode)n.setUnitTestMode(true);return n}static isPureDevelopmentConfig(e){return"development"===xtrem_core_1.ConfigManager.current.deploymentMode&&!e.testMode}static getDevUrl(e,t,r,n){const o=this.getLogger(),s=xtrem_core_1.ConfigManager.current,i=Buffer.from(JSON.stringify({objectKey:t})).toString("base64");let a=`${s.security?.redirectUrl||`http://localhost:${s.server?.port||"8240"}`}/dev/${e}/${i}`;if(n)a=`${a}?filename=${encodeURIComponent(n)}`;return o.info(`[Dev] upload url ${r} for '${t}': ${a}`),a}static generateAttachmentDownloadPresignedUrl(e,t,r,n){const o=this.getFileStorageHandler(e);if(this.isPureDevelopmentConfig(e))return Promise.resolve(this.getDevUrl("attachments",t,"AttachmentDownloadPresignedUrl",n));return o.generateAttachmentDownloadPresignedUrl(this.getTenantId(e),t,r,n)}static generateAttachmentUploadPresignedUrl(e,t,r){const n=this.getFileStorageHandler(e);if(this.isPureDevelopmentConfig(e))return Promise.resolve(this.getDevUrl("attachments",t,"AttachmentUploadPresignedUrl"));return n.generateAttachmentUploadPresignedUrl(this.getTenantId(e),t,r?.ttlSeconds)}static getUploadPresignedUrl(e,t,r){const n=this.getFileStorageHandler(e);if(this.isPureDevelopmentConfig(e))return Promise.resolve(this.getDevUrl("uploads",t,"UploadPresignedUrl"));return n.generateUploadPresignedUrl(this.getTenantId(e),t,r)}static getDownloadPresignedUrl(e,t,r){const n=this.getFileStorageHandler(e);if(this.isPureDevelopmentConfig(e))return Promise.resolve(this.getDevUrl("uploads",t,"DownloadPresignedUrl",r?.filename));return n.generateDownloadPresignedUrl(this.getTenantId(e),t,r?.ttlSeconds,r?.filename)}static createFile(e,t,r,n,o){return this.getFileStorageHandler(e).createFile(this.getTenantId(e),t,r,n,o)}static async readAsyncUploadResult(e,t,r){const n=this.getFileStorageHandler(e),o=await n.readAsyncContextResult(this.getTenantId(e),t,async_context_provider_1.ASYNC_CONTEXT_CONST[r]);return this.stripVoid(o)}static async readFile(e,t){const r=this.getFileStorageHandler(e),n=await r.readFile(this.getTenantId(e),t);return this.stripVoid(n)}static list(e,t,r){return this.getFileStorageHandler(t).list(e,this.getTenantId(t),r)}static getTenantApps(e){let t;const{aws:r,xtremDeploymentCoreTableName:n,clusterId:o}=xtrem_core_1.ConfigManager.current;if(r&&o&&n)t=xtrem_infra_1.TenantAppHelper.getCloudImplementation(r,n,o);else if("development"===xtrem_core_1.ConfigManager.current.deploymentMode){const e=path.join(__dirname,__dirname.includes("/build/")?"../":"./","../../../../../apps.yml");if(fs.existsSync(e))t=xtrem_infra_1.TenantAppHelper.getLocalDeveloperImplementation(e);else return this.logger.warn("apps.yml file not found, cannot get tenant apps."),Promise.resolve(null)}else return this.logger.warn("Incomplete configuration, cannot get tenant apps."),Promise.resolve(null);return t.getAppsOfTenant({tenantId:e,cluster:o})}}exports.InfrastructureHelper=InfrastructureHelper;
//# sourceMappingURL=infrastructure-helper.js.map