"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CachedTenantAppDataStore = void 0;
const cache_manager_1 = require("cache-manager");
const MAX_TENANT_IN_CACHE = 1000;
const TENANT_CACHE_TTL_MS = 1000 * 60 * 5;
class CachedTenantAppDataStore {
    tenantCache;
    actualTenantAppDatasource;
    cacheTTLInMS;
    constructor(actualTenantAppDatasource, cacheTTLInMS = TENANT_CACHE_TTL_MS) {
        this.actualTenantAppDatasource = actualTenantAppDatasource;
        this.cacheTTLInMS = cacheTTLInMS;
        (0, cache_manager_1.caching)("memory", { max: MAX_TENANT_IN_CACHE, ttl: this.cacheTTLInMS }).then((memcache) => this.tenantCache = memcache);
    }
    async getAppsOfTenant(tenantId) {
        if (!this.tenantCache) {
            // can happen in race condition in unit tests
            this.tenantCache = await (0, cache_manager_1.caching)("memory", { max: MAX_TENANT_IN_CACHE, ttl: this.cacheTTLInMS });
        }
        const cacheResult = await this.tenantCache.get(tenantId);
        if (cacheResult) {
            return cacheResult;
        }
        const appsOfTenant = await this.actualTenantAppDatasource.getAppsOfTenant(tenantId);
        this.tenantCache.set(tenantId, appsOfTenant).then();
        return appsOfTenant;
    }
}
exports.CachedTenantAppDataStore = CachedTenantAppDataStore;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiQ2FjaGVkVGVuYW50QXBwRGF0YVN0b3JlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vc3JjL3RlbmFudEFwcFJlZ2lzdHJ5L2RhdGFzb3VyY2UvQ2FjaGVkVGVuYW50QXBwRGF0YVN0b3JlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLGlEQUFxRDtBQUlyRCxNQUFNLG1CQUFtQixHQUFHLElBQUksQ0FBQztBQUNqQyxNQUFNLG1CQUFtQixHQUFHLElBQUksR0FBRyxFQUFFLEdBQUcsQ0FBQyxDQUFDO0FBRTFDLE1BQWEsd0JBQXdCO0lBRWpDLFdBQVcsQ0FBMEI7SUFDckMseUJBQXlCLENBQXNCO0lBQy9DLFlBQVksQ0FBUztJQUdyQixZQUFZLHlCQUE4QyxFQUFFLFlBQVksR0FBRyxtQkFBbUI7UUFDMUYsSUFBSSxDQUFDLHlCQUF5QixHQUFHLHlCQUF5QixDQUFDO1FBQzNELElBQUksQ0FBQyxZQUFZLEdBQUcsWUFBWSxDQUFDO1FBQ2pDLElBQUEsdUJBQU8sRUFBQyxRQUFRLEVBQUUsRUFBRSxHQUFHLEVBQUUsbUJBQW1CLEVBQUUsR0FBRyxFQUFFLElBQUksQ0FBQyxZQUFZLEVBQUUsQ0FBQyxDQUFDLElBQUksQ0FBQyxDQUFDLFFBQVEsRUFBRSxFQUFFLENBQUMsSUFBSSxDQUFDLFdBQVcsR0FBRyxRQUFRLENBQUMsQ0FBQztJQUU1SCxDQUFDO0lBRUQsS0FBSyxDQUFDLGVBQWUsQ0FBQyxRQUFnQjtRQUVsQyxJQUFJLENBQUMsSUFBSSxDQUFDLFdBQVcsRUFBRSxDQUFDO1lBQ3BCLDZDQUE2QztZQUM3QyxJQUFJLENBQUMsV0FBVyxHQUFHLE1BQU0sSUFBQSx1QkFBTyxFQUFDLFFBQVEsRUFBRSxFQUFFLEdBQUcsRUFBRSxtQkFBbUIsRUFBRSxHQUFHLEVBQUUsSUFBSSxDQUFDLFlBQVksRUFBRSxDQUFDLENBQUM7UUFDckcsQ0FBQztRQUVELE1BQU0sV0FBVyxHQUFHLE1BQU0sSUFBSSxDQUFDLFdBQVcsQ0FBQyxHQUFHLENBQTBCLFFBQVEsQ0FBQyxDQUFDO1FBRWxGLElBQUksV0FBVyxFQUFFLENBQUM7WUFDZCxPQUFPLFdBQVcsQ0FBQztRQUN2QixDQUFDO1FBRUQsTUFBTSxZQUFZLEdBQUcsTUFBTSxJQUFJLENBQUMseUJBQXlCLENBQUMsZUFBZSxDQUFDLFFBQVEsQ0FBQyxDQUFDO1FBQ3BGLElBQUksQ0FBQyxXQUFXLENBQUMsR0FBRyxDQUFDLFFBQVEsRUFBQyxZQUFZLENBQUMsQ0FBQyxJQUFJLEVBQUUsQ0FBQztRQUNuRCxPQUFPLFlBQVksQ0FBQztJQUV4QixDQUFDO0NBTUo7QUFyQ0QsNERBcUNDIn0=