"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppsYmlTenantAppDatasource = void 0;
const fs_1 = require("fs");
const yaml = require("js-yaml");
/***
 * Provide list of apps by reading apps.yml, used for local developer implementation
 */
class AppsYmlTenantAppDatasource {
    appsFileLocation;
    apps;
    hardcodedClusterName;
    constructor(appsFileLocation, hardcodedClusterName) {
        this.appsFileLocation = appsFileLocation;
        this.hardcodedClusterName = hardcodedClusterName;
    }
    async loadAppsFromFile() {
        try {
            const fileContents = await fs_1.promises.readFile(this.appsFileLocation, 'utf8');
            const parsedYaml = yaml.load(fileContents);
            this.apps = {};
            this.apps[this.hardcodedClusterName] = Object.keys(parsedYaml.apps);
        }
        catch (error) {
            console.error(`Error reading or parsing apps.yml file  ${this.appsFileLocation} .`, error);
            this.apps = {};
        }
    }
    async getAppsOfTenant(_tenantId) {
        if (!this.apps) {
            await this.loadAppsFromFile();
        }
        return this.apps || {};
    }
}
exports.AppsYmlTenantAppDatasource = AppsYmlTenantAppDatasource;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiQXBwc1ltbFRlbmFudEFwcERhdGFzb3VyY2UuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi9zcmMvdGVuYW50QXBwUmVnaXN0cnkvZGF0YXNvdXJjZS9BcHBzWW1sVGVuYW50QXBwRGF0YXNvdXJjZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFDQSwyQkFBb0M7QUFFcEMsZ0NBQWdDO0FBVWhDOztHQUVHO0FBQ0gsTUFBYSwwQkFBMEI7SUFFbEIsZ0JBQWdCLENBQVU7SUFDbkMsSUFBSSxDQUF3QztJQUNuQyxvQkFBb0IsQ0FBUztJQUc5QyxZQUFZLGdCQUF3QixFQUFFLG9CQUE2QjtRQUMvRCxJQUFJLENBQUMsZ0JBQWdCLEdBQUcsZ0JBQWdCLENBQUM7UUFDekMsSUFBSSxDQUFDLG9CQUFvQixHQUFHLG9CQUFvQixDQUFDO0lBQ3JELENBQUM7SUFFTyxLQUFLLENBQUMsZ0JBQWdCO1FBQzFCLElBQUksQ0FBQztZQUNELE1BQU0sWUFBWSxHQUFHLE1BQU0sYUFBRSxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLEVBQUUsTUFBTSxDQUFDLENBQUM7WUFDdEUsTUFBTSxVQUFVLEdBQUcsSUFBSSxDQUFDLElBQUksQ0FBQyxZQUFZLENBQXlCLENBQUM7WUFDbkUsSUFBSSxDQUFDLElBQUksR0FBRyxFQUFFLENBQUM7WUFDZixJQUFJLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxvQkFBb0IsQ0FBQyxHQUFJLE1BQU0sQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxDQUFDO1FBQ3pFLENBQUM7UUFBQyxPQUFPLEtBQUssRUFBRSxDQUFDO1lBQ2IsT0FBTyxDQUFDLEtBQUssQ0FBQywyQ0FBMkMsSUFBSSxDQUFDLGdCQUFnQixJQUFJLEVBQUUsS0FBSyxDQUFDLENBQUM7WUFDM0YsSUFBSSxDQUFDLElBQUksR0FBRyxFQUFFLENBQUM7UUFDbkIsQ0FBQztJQUNMLENBQUM7SUFHRCxLQUFLLENBQUMsZUFBZSxDQUFDLFNBQWlCO1FBQ25DLElBQUssQ0FBRSxJQUFJLENBQUMsSUFBSSxFQUFFLENBQUM7WUFDZixNQUFNLElBQUksQ0FBQyxnQkFBZ0IsRUFBRSxDQUFDO1FBQ2xDLENBQUM7UUFDRCxPQUFPLElBQUksQ0FBQyxJQUFJLElBQUksRUFBRSxDQUFDO0lBQzNCLENBQUM7Q0FHSjtBQWpDRCxnRUFpQ0MifQ==